/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.nn;

import ai.djl.nn.AbstractBaseBlock;
import ai.djl.nn.Block;
import ai.djl.nn.BlockList;
import ai.djl.nn.Parameter;
import ai.djl.nn.ParameterList;
import ai.djl.util.Pair;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public abstract class AbstractBlock
extends AbstractBaseBlock {
    protected BlockList children = new BlockList();
    protected LinkedHashMap<String, Parameter> parameters = new LinkedHashMap();

    public AbstractBlock() {
    }

    public AbstractBlock(byte version) {
        super(version);
    }

    protected final <B extends Block> B addChildBlock(String name, B block) {
        int childNumber = this.children.size() + 1;
        this.children.add(String.format(Locale.ROOT, "%02d%s", childNumber, name), block);
        return block;
    }

    protected final <P extends Parameter> P addParameter(P parameter) {
        this.parameters.put(parameter.getName(), parameter);
        return parameter;
    }

    @Override
    public BlockList getChildren() {
        BlockList defensiveCopy = new BlockList(this.children.size());
        for (Pair entry : this.children) {
            defensiveCopy.add(entry);
        }
        return defensiveCopy;
    }

    @Override
    public ParameterList getDirectParameters() {
        return new ParameterList((Map<String, Parameter>)this.parameters);
    }
}

