/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.training.optimizer;

import ai.djl.Device;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.internal.NDArrayEx;
import ai.djl.training.optimizer.Optimizer;
import ai.djl.training.tracker.Tracker;
import ai.djl.util.Preconditions;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class Nag
extends Optimizer {
    private Tracker learningRateTracker;
    private float momentum;
    private Map<String, Map<Device, NDArray>> momentumStates;

    protected Nag(Builder builder) {
        super(builder);
        this.learningRateTracker = builder.learningRateTracker;
        this.momentum = builder.momentum;
        this.momentumStates = new ConcurrentHashMap<String, Map<Device, NDArray>>();
    }

    @Override
    public void update(String parameterId, NDArray weight, NDArray grad) {
        float newLearningRate = this.learningRateTracker.getNewValue(this.updateCount(parameterId));
        float weightDecay = this.getWeightDecay();
        NDList inputs = this.momentum != 0.0f ? new NDList(weight, grad, this.withDefaultState(this.momentumStates, parameterId, weight.getDevice(), k -> weight.zerosLike())) : new NDList(weight, grad);
        NDList weights = new NDList(weight);
        NDArrayEx ex = weight.getNDArrayInternal();
        ex.nagUpdate(inputs, weights, newLearningRate, weightDecay, this.rescaleGrad, this.clipGrad, this.momentum);
    }

    public static final class Builder
    extends Optimizer.OptimizerBuilder<Builder> {
        Tracker learningRateTracker;
        float momentum;

        Builder() {
        }

        public Builder setLearningRateTracker(Tracker learningRateTracker) {
            this.learningRateTracker = learningRateTracker;
            return this;
        }

        public Builder setMomentum(float momentum) {
            this.momentum = momentum;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        public Nag build() {
            Objects.requireNonNull(this.learningRateTracker, "No lrTracker set");
            Preconditions.checkArgument(this.momentum != 0.0f, "The momentum should be set");
            return new Nag(this);
        }
    }
}

