/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.nlp.translator;

import ai.djl.modality.nlp.qa.QAInput;
import ai.djl.translate.ArgumentsUtil;
import ai.djl.translate.Batchifier;
import ai.djl.translate.Translator;
import java.util.Locale;
import java.util.Map;

public abstract class QATranslator
implements Translator<QAInput, String> {
    protected Batchifier batchifier;
    protected String tokenizerName;
    protected String vocab;
    protected Locale locale;
    protected boolean toLowerCase;
    protected boolean includeTokenTypes;
    protected boolean padding;
    protected boolean truncation;
    protected int maxLength;
    protected int maxLabels;

    protected QATranslator(BaseBuilder<?> builder) {
        this.batchifier = builder.batchifier;
        this.tokenizerName = builder.tokenizerName;
        this.vocab = builder.vocab;
        this.locale = builder.locale;
        this.toLowerCase = builder.toLowerCase;
        this.includeTokenTypes = builder.includeTokenTypes;
        this.padding = builder.padding;
        this.truncation = builder.truncation;
        this.maxLength = builder.maxLength;
        this.maxLabels = builder.maxLabels;
    }

    @Override
    public Batchifier getBatchifier() {
        return this.batchifier;
    }

    public static abstract class BaseBuilder<T extends BaseBuilder> {
        Batchifier batchifier = Batchifier.STACK;
        String tokenizerName;
        String vocab = "vocab.txt";
        Locale locale = Locale.ROOT;
        boolean toLowerCase;
        boolean includeTokenTypes;
        boolean padding;
        boolean truncation;
        int maxLength = 128;
        int maxLabels;

        public T optBatchifier(Batchifier batchifier) {
            this.batchifier = batchifier;
            return this.self();
        }

        public T optTokenizer(String tokenizer) {
            this.tokenizerName = tokenizer;
            return this.self();
        }

        public T optVocab(String vocab) {
            if (vocab != null) {
                this.vocab = vocab;
            }
            return this.self();
        }

        public T optLocale(String locale) {
            if (locale != null) {
                this.locale = Locale.forLanguageTag(locale);
            }
            return this.self();
        }

        public T optToLowerCase(boolean toLowerCase) {
            this.toLowerCase = toLowerCase;
            return this.self();
        }

        public T optIncludeTokenTypes(boolean includeTokenTypes) {
            this.includeTokenTypes = includeTokenTypes;
            return this.self();
        }

        public T optPadding(boolean padding) {
            this.padding = padding;
            return this.self();
        }

        public T optTruncation(boolean truncation) {
            this.truncation = truncation;
            return this.self();
        }

        public T optMaxLength(int maxLength) {
            this.maxLength = maxLength;
            return this.self();
        }

        public T optMaxLabels(int maxLabels) {
            this.maxLabels = maxLabels;
            return this.self();
        }

        public void configure(Map<String, ?> arguments) {
            this.optTokenizer(ArgumentsUtil.stringValue(arguments, "tokenizer"));
            this.optVocab(ArgumentsUtil.stringValue(arguments, "vocab"));
            this.optLocale(ArgumentsUtil.stringValue(arguments, "locale"));
            this.optToLowerCase(ArgumentsUtil.booleanValue(arguments, "toLowerCase"));
            this.optIncludeTokenTypes(ArgumentsUtil.booleanValue(arguments, "includeTokenTypes"));
            this.optPadding(ArgumentsUtil.booleanValue(arguments, "padding"));
            this.optTruncation(ArgumentsUtil.booleanValue(arguments, "truncation"));
            this.optMaxLength(ArgumentsUtil.intValue(arguments, "maxLength", 128));
            this.optMaxLabels(ArgumentsUtil.intValue(arguments, "maxLabels"));
        }

        protected abstract T self();
    }
}

