/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.util;

import ai.djl.engine.Engine;
import ai.djl.util.JsonUtils;
import ai.djl.util.Utils;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Ec2Utils {
    private static final Logger logger = LoggerFactory.getLogger(Ec2Utils.class);
    private static final String ENDPOINT_METADATA_FILE = "/opt/ml/.sagemaker_infra/endpoint-metadata.json";
    private static final String TOKEN_URL = "http://169.254.169.254/latest/api/token";
    private static final String EC2_METADATA = "http://169.254.169.254/latest/meta-data/";
    private static final long ONE_DAY = Duration.ofDays(1L).toMillis();
    private static long lastCheckIn;

    private Ec2Utils() {
    }

    public static boolean isSageMaker() {
        try {
            return Files.exists(Paths.get(ENDPOINT_METADATA_FILE, new String[0]), new LinkOption[0]);
        }
        catch (SecurityException e) {
            logger.warn("Security manager doesn't allow access file");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readMetadata(String key) {
        block13: {
            String reason;
            int statusCode;
            HttpURLConnection conn = null;
            try {
                String header = "X-aws-ec2-metadata-token";
                String token = Ec2Utils.getToken();
                String url = EC2_METADATA + key;
                conn = Ec2Utils.openConnection(new URL(url), "GET", header, token);
                statusCode = conn.getResponseCode();
                if (statusCode == 200) {
                    try (InputStream is = conn.getInputStream();){
                        String string = Utils.toString(is);
                        return string;
                    }
                }
                reason = conn.getResponseMessage();
            }
            catch (IOException iOException) {
                break block13;
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
            logger.debug("Failed to get EC2 metadata: {} {}", (Object)statusCode, (Object)reason);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void callHome(String engine) {
        String region;
        String instanceId;
        if (Boolean.getBoolean("offline") || Boolean.parseBoolean(Utils.getEnvOrSystemProperty("OPT_OUT_TRACKING")) || System.currentTimeMillis() - lastCheckIn < ONE_DAY) {
            return;
        }
        lastCheckIn = System.currentTimeMillis();
        if (Ec2Utils.isSageMaker()) {
            instanceId = Ec2Utils.readEndpointMetadata("ResourceId");
            region = Utils.getenv("AWS_REGION");
        } else {
            instanceId = Ec2Utils.readMetadata("instance-id");
            region = Ec2Utils.readMetadata("placement/region");
        }
        if (instanceId == null || region == null || region.length() == 0) {
            return;
        }
        String url = "https://djl-telemetry-" + region + ".s3." + region + ".amazonaws.com/telemetry.txt?instance-id=" + instanceId + "&version=" + Engine.getDjlVersion() + "&engine=" + engine;
        HttpURLConnection conn = null;
        try {
            conn = Ec2Utils.openConnection(new URL(url), "GET", null, null);
            int statusCode = conn.getResponseCode();
            if (statusCode != 200) {
                logger.debug("telemetry: {} {}", (Object)statusCode, (Object)conn.getResponseMessage());
            } else {
                logger.info("DJL will collect telemetry to help us better understand our users\u2019 needs, diagnose issues, and deliver additional features. If you would like to learn more or opt-out please go to: https://docs.djl.ai/docs/telemetry.html for more information.");
            }
        }
        catch (IOException e) {
            logger.debug("Failed call home.");
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getToken() {
        HttpURLConnection conn = null;
        try {
            String header = "X-aws-ec2-metadata-token-ttl-seconds";
            conn = Ec2Utils.openConnection(new URL(TOKEN_URL), "PUT", header, "21600");
            int statusCode = conn.getResponseCode();
            if (statusCode == 200) {
                try (InputStream is = conn.getInputStream();){
                    String string = Utils.toString(is);
                    return string;
                }
            }
            logger.debug("EC2 IMDSv2: {} {}", (Object)statusCode, (Object)conn.getResponseMessage());
        }
        catch (IOException iOException) {
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }

    private static String readEndpointMetadata(String key) {
        String string;
        block8: {
            Path path = Paths.get(ENDPOINT_METADATA_FILE, new String[0]);
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                JsonObject json = (JsonObject)JsonUtils.GSON.fromJson((Reader)reader, JsonObject.class);
                string = json.get(key).getAsString();
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            ((Reader)reader).close();
        }
        return string;
    }

    private static HttpURLConnection openConnection(URL url, String method, String header, String value) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection(Proxy.NO_PROXY);
        conn.setConnectTimeout(1000);
        conn.setReadTimeout(1000);
        conn.setRequestMethod(method);
        conn.setDoOutput(true);
        conn.addRequestProperty("Accept", "*/*");
        conn.addRequestProperty("User-Agent", "djl");
        if (value != null) {
            conn.addRequestProperty(header, value);
        }
        conn.setInstanceFollowRedirects(false);
        conn.connect();
        return conn;
    }
}

