/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.training.optimizer;

import ai.djl.Device;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.internal.NDArrayEx;
import ai.djl.ndarray.types.SparseFormat;
import ai.djl.training.optimizer.Optimizer;
import ai.djl.training.tracker.ParameterTracker;
import ai.djl.training.tracker.Tracker;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Adagrad
extends Optimizer {
    private ParameterTracker learningRateTracker;
    private float epsilon;
    private Map<String, Map<Device, NDArray>> history;

    protected Adagrad(Builder builder) {
        super(builder);
        this.learningRateTracker = builder.learningRateTracker;
        this.epsilon = builder.epsilon;
        this.history = new ConcurrentHashMap<String, Map<Device, NDArray>>();
    }

    @Override
    public void update(String parameterId, NDArray weight, NDArray grad) {
        int t = this.updateCount(parameterId);
        float newLearningRate = this.learningRateTracker.getNewValue(parameterId, t);
        float weightDecay = this.getWeightDecay();
        if (Float.isNaN(newLearningRate) || Float.isNaN(weightDecay) || Float.isInfinite(newLearningRate) || Float.isInfinite(weightDecay)) {
            throw new IllegalStateException("learning rate or weight decay is nan or infinite");
        }
        NDList inputs = new NDList(weight, grad.toSparse(SparseFormat.ROW_SPARSE), this.withDefaultState(this.history, parameterId, weight.getDevice(), k -> weight.zerosLike()));
        NDList weights = new NDList(weight);
        NDArrayEx ex = weight.getNDArrayInternal();
        ex.adagradUpdate(inputs, weights, newLearningRate, weightDecay, this.rescaleGrad, this.clipGrad, this.epsilon);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends Optimizer.OptimizerBuilder<Builder> {
        private ParameterTracker learningRateTracker = Tracker.fixed(0.001f);
        private float epsilon = 1.0E-8f;

        Builder() {
        }

        @Override
        protected Builder self() {
            return this;
        }

        public Builder optLearningRateTracker(ParameterTracker learningRateTracker) {
            this.learningRateTracker = learningRateTracker;
            return this;
        }

        public Builder optEpsilon(float epsilon) {
            this.epsilon = epsilon;
            return this;
        }

        public Adagrad build() {
            return new Adagrad(this);
        }
    }
}

