/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.translate;

import ai.djl.Model;
import ai.djl.translate.ArgumentsUtil;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.Pair;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeferredTranslatorFactory
implements TranslatorFactory {
    private static final Logger logger = LoggerFactory.getLogger(DeferredTranslatorFactory.class);

    @Override
    public Set<Pair<Type, Type>> getSupportedTypes() {
        return Collections.emptySet();
    }

    @Override
    public boolean isSupported(Class<?> input, Class<?> output) {
        return true;
    }

    @Override
    public <I, O> Translator<I, O> newInstance(Class<I> input, Class<O> output, Model model, Map<String, ?> arguments) throws TranslateException {
        String factoryClass = ArgumentsUtil.stringValue(arguments, "translatorFactory");
        if (factoryClass == null || factoryClass.isEmpty()) {
            throw new TranslateException("No translatorFactory defined.");
        }
        TranslatorFactory factory = this.loadTranslatorFactory(factoryClass);
        if (factory == null) {
            throw new TranslateException("Failed to load translatorFactory: " + factoryClass);
        }
        if (!factory.isSupported(input, output)) {
            throw new TranslateException(factoryClass + " doesn't support Input/Output.");
        }
        logger.info("Using TranslatorFactory: {}", (Object)factoryClass);
        return factory.newInstance(input, output, model, arguments);
    }

    private TranslatorFactory loadTranslatorFactory(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Class<TranslatorFactory> subclass = clazz.asSubclass(TranslatorFactory.class);
            Constructor<TranslatorFactory> constructor = subclass.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (Throwable e) {
            logger.trace("Not able to load TranslatorFactory: {}", (Object)className, (Object)e);
            return null;
        }
    }
}

