/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.metric;

import java.util.concurrent.ConcurrentHashMap;

public enum Unit {
    MICROSECONDS("Microseconds"),
    MILLISECONDS("Milliseconds"),
    BYTES("Bytes"),
    KILOBYTES("Kilobytes"),
    MEGABYTES("Megabytes"),
    GIGABYTES("Gigabytes"),
    TERABYTES("Terabytes"),
    BITS("Bits"),
    KILOBITS("Kilobits"),
    MEGABITS("Megabits"),
    GIGABITS("Gigabits"),
    TERABITS("Terabits"),
    PERCENT("Percent"),
    COUNT("Count"),
    BYTES_PER_SECOND("Bytes/Second"),
    KILOBYTES_PER_SECOND("Kilobytes/Second"),
    MEGABYTES_PER_SECOND("Megabytes/Second"),
    GIGABYTES_PER_SECOND("Gigabytes/Second"),
    TERABYTES_PER_SECOND("Terabytes/Second"),
    BITS_PER_SECOND("Bits/Second"),
    KILOBITS_PER_SECOND("Kilobits/Second"),
    MEGABITS_PER_SECOND("Megabits/Second"),
    GIGABITS_PER_SECOND("Gigabits/Second"),
    TERABITS_PER_SECOND("Terabits/Second"),
    COUNT_PER_SECOND("Count/Second"),
    COUNT_PER_ITEM("Count/Item"),
    NONE("None");

    private static final ConcurrentHashMap<String, Unit> MAP;
    private final String value;

    private Unit(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static Unit fromValue(String value) {
        Unit ret = MAP.get(value);
        if (ret == null) {
            throw new IllegalArgumentException("Invalid unit value: " + value);
        }
        return ret;
    }

    static {
        MAP = new ConcurrentHashMap();
        for (Unit unit : Unit.values()) {
            MAP.put(unit.value, unit);
        }
    }
}

