/*
 * Decompiled with CFR 0.152.
 */
package ai.ost.fastjson_protobuf;

import ai.ost.fastjson_protobuf.ParserConfig;
import ai.ost.fastjson_protobuf.SerializeConfig;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageNotReadableException;

public class FastJsonProtobufHttpMessageConverter
extends FastJsonHttpMessageConverter {
    public FastJsonProtobufHttpMessageConverter() {
        FastJsonConfig config = this.getFastJsonConfig();
        config.setSerializeConfig((com.alibaba.fastjson.serializer.SerializeConfig)new SerializeConfig());
        config.setParserConfig((com.alibaba.fastjson.parser.ParserConfig)new ParserConfig());
    }

    public void disableProtobuf() {
        FastJsonConfig config = this.getFastJsonConfig();
        this.disableProtobufWriter(config.getSerializeConfig());
        this.disableProtobufParser(config.getParserConfig());
    }

    private void disableProtobufWriter(com.alibaba.fastjson.serializer.SerializeConfig serializeConfig) {
        if (SerializeConfig.class.isAssignableFrom(serializeConfig.getClass())) {
            ((SerializeConfig)serializeConfig).disableProtobuf();
        }
    }

    private void disableProtobufParser(com.alibaba.fastjson.parser.ParserConfig parserConfig) {
        if (ParserConfig.class.isAssignableFrom(parserConfig.getClass())) {
            ((ParserConfig)parserConfig).disableProtobuf();
        }
    }

    public Object read(Type type, Class<?> contextClass, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        return this.readType(this.getType(type, contextClass), inputMessage);
    }

    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        return this.readType(this.getType(clazz, null), inputMessage);
    }

    private Object readType(Type type, HttpInputMessage inputMessage) throws IOException {
        InputStream is;
        try {
            is = inputMessage.getBody();
        }
        catch (IOException e) {
            throw new IOException("I/O error while getting input body", e);
        }
        FastJsonConfig config = this.getFastJsonConfig();
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy((InputStream)is, (Writer)writer, (Charset)config.getCharset());
        }
        catch (IOException e) {
            throw new IOException("I/O error while reading input message", e);
        }
        try {
            return JSON.parseObject((String)writer.toString(), (Type)type, (com.alibaba.fastjson.parser.ParserConfig)config.getParserConfig(), (Feature[])config.getFeatures());
        }
        catch (JSONException e) {
            throw new HttpMessageNotReadableException("JSON parse error: " + e.getMessage(), (Throwable)e);
        }
    }
}

