/*
 * Decompiled with CFR 0.152.
 */
package ai.ost.fastjson_protobuf;

import ai.ost.fastjson_protobuf.InvalidProtocolBufferException;
import ai.ost.fastjson_protobuf.InvalidProtocolBufferMessageClass;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONLexerBase;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;

public class GeneratedMessageV3Codec
implements ObjectSerializer,
ObjectDeserializer {
    static final GeneratedMessageV3Codec instance = new GeneratedMessageV3Codec();
    private static JsonFormat.Printer printer = JsonFormat.printer().omittingInsignificantWhitespace().preservingProtoFieldNames();
    private static JsonFormat.Parser parser = JsonFormat.parser().ignoringUnknownFields();

    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        String json;
        GeneratedMessageV3 o = (GeneratedMessageV3)object;
        try {
            json = printer.print((MessageOrBuilder)o);
        }
        catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw new InvalidProtocolBufferException((IOException)((Object)e));
        }
        serializer.out.write(json);
    }

    public <T> T deserialze(DefaultJSONParser jsonParser, Type type, Object fieldName) {
        int endToken;
        Message.Builder builder;
        Class clazz = (Class)type;
        try {
            builder = (Message.Builder)clazz.getMethod("newBuilder", new Class[0]).invoke((Object)clazz, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new InvalidProtocolBufferMessageClass("invalid instance");
        }
        catch (IllegalArgumentException e) {
            throw new InvalidProtocolBufferMessageClass("invalid arguments");
        }
        catch (InvocationTargetException e) {
            throw new InvalidProtocolBufferMessageClass("invalid target");
        }
        catch (IllegalAccessException e) {
            throw new InvalidProtocolBufferMessageClass("invalid access");
        }
        JSONLexerBase lexer = (JSONLexerBase)jsonParser.getLexer();
        int startToken = lexer.token();
        if (startToken == 12) {
            endToken = 13;
        } else if (startToken == 14) {
            endToken = 15;
        } else {
            String str = this.subString(lexer, startToken);
            throw new JSONException(str.isEmpty() ? "Expect message object" : "Expect message object but got: " + str);
        }
        lexer.nextToken();
        int startPos = lexer.pos() - 1;
        int endPos = 0;
        int expectR = 1;
        while (true) {
            int current;
            if ((current = lexer.token()) == endToken && --expectR == 0) break;
            if (current == startToken) {
                ++expectR;
            }
            lexer.nextToken();
        }
        endPos = lexer.pos();
        lexer.nextToken(16);
        String json = lexer.subString(startPos, endPos - startPos + 1);
        try {
            parser.merge(json, builder);
        }
        catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw new InvalidProtocolBufferException((IOException)((Object)e));
        }
        return (T)builder.build();
    }

    private String subString(JSONLexerBase lexer, int token) {
        switch (token) {
            case 6: {
                return "true";
            }
            case 7: {
                return "false";
            }
            case 4: {
                return "\"" + lexer.stringVal() + "\"";
            }
            case 3: {
                return "a float number";
            }
            case 2: {
                return "an integer";
            }
        }
        return "";
    }

    public int getFastMatchToken() {
        return 12;
    }
}

