/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.spring;

import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Resource;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLType {
    Transformer transformer;
    Pattern paths;
    String root;
    static Pattern QN = Pattern.compile("[_A-Za-z$][_A-Za-z0-9$]*(\\.[_A-Za-z$][_A-Za-z0-9$]*)*");

    public XMLType(URL source, String root, String paths) throws Exception {
        this.transformer = this.getTransformer(source);
        this.paths = Pattern.compile(paths);
        this.root = root;
    }

    public Set<String> analyze(InputStream in) throws Exception {
        HashSet<String> refers = new HashSet<String>();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        StreamResult r = new StreamResult(bout);
        StreamSource s = new StreamSource(in);
        this.transformer.transform(s, r);
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        bout.close();
        BufferedReader br = new BufferedReader(new InputStreamReader(bin));
        String line = br.readLine();
        while (line != null) {
            if ((line = line.trim()).length() > 0) {
                String[] parts = line.split("\\s*,\\s*");
                int i = 0;
                while (i < parts.length) {
                    int n = parts[i].lastIndexOf(46);
                    if (n > 0) {
                        refers.add(parts[i].subSequence(0, n).toString());
                    }
                    ++i;
                }
            }
            line = br.readLine();
        }
        br.close();
        return refers;
    }

    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        Jar jar = analyzer.getJar();
        Map<String, Resource> dir = jar.getDirectories().get(this.root);
        if (dir == null || dir.isEmpty()) {
            Resource resource = jar.getResource(this.root);
            if (resource != null) {
                this.process(analyzer, this.root, resource);
            }
            return false;
        }
        for (Map.Entry<String, Resource> entry : dir.entrySet()) {
            String path = entry.getKey();
            Resource resource = entry.getValue();
            if (!this.paths.matcher(path).matches()) continue;
            this.process(analyzer, path, resource);
        }
        return false;
    }

    private void process(Analyzer analyzer, String path, Resource resource) {
        try {
            InputStream in = resource.openInputStream();
            Set<String> set = this.analyze(in);
            in.close();
            for (String pack : set) {
                if (!QN.matcher(pack).matches()) {
                    analyzer.warning("Package does not seem a package in spring resource (" + path + "): " + pack, new Object[0]);
                }
                if (analyzer.getReferred().containsKey(pack)) continue;
                analyzer.getReferred().put(pack, new LinkedHashMap());
            }
        }
        catch (Exception e) {
            analyzer.error("Unexpected exception in processing spring resources(" + path + "): " + e, new Object[0]);
        }
    }

    protected Transformer getTransformer(URL url) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        StreamSource source = new StreamSource(url.openStream());
        return tf.newTransformer(source);
    }
}

