/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.security.cert.CRLException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.x509.NoSuchStoreException;
import org.bouncycastle.x509.X509CollectionStoreParameters;
import org.bouncycastle.x509.X509Store;
import org.bouncycastle.x509.X509StoreParameters;
import org.bouncycastle.x509.X509V2AttributeCertificate;

class CMSSignedHelper {
    static final CMSSignedHelper INSTANCE = new CMSSignedHelper();
    private static final Map encryptionAlgs = new HashMap();
    private static final Map digestAlgs = new HashMap();
    private static final Map digestAliases = new HashMap();

    CMSSignedHelper() {
    }

    private static void addEntries(DERObjectIdentifier dERObjectIdentifier, String string, String string2) {
        digestAlgs.put(dERObjectIdentifier.getId(), string);
        encryptionAlgs.put(dERObjectIdentifier.getId(), string2);
    }

    String getDigestAlgName(String string) {
        String string2 = (String)digestAlgs.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    String[] getDigestAliases(String string) {
        String[] stringArray = (String[])digestAliases.get(string);
        if (stringArray != null) {
            return stringArray;
        }
        return new String[0];
    }

    String getEncryptionAlgName(String string) {
        String string2 = (String)encryptionAlgs.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    MessageDigest getDigestInstance(String string, String string2) throws NoSuchProviderException, NoSuchAlgorithmException {
        try {
            return this.createDigestInstance(string, string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            String[] stringArray = this.getDigestAliases(string);
            for (int i = 0; i != stringArray.length; ++i) {
                try {
                    return this.createDigestInstance(stringArray[i], string2);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                    continue;
                }
            }
            if (string2 != null) {
                return this.getDigestInstance(string, null);
            }
            throw noSuchAlgorithmException;
        }
    }

    private MessageDigest createDigestInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 != null) {
            return MessageDigest.getInstance(string, string2);
        }
        return MessageDigest.getInstance(string);
    }

    Signature getSignatureInstance(String string, String string2) throws NoSuchProviderException, NoSuchAlgorithmException {
        if (string2 != null) {
            return Signature.getInstance(string, string2);
        }
        return Signature.getInstance(string);
    }

    X509Store createAttributeStore(String string, String string2, ASN1Set aSN1Set) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        ArrayList<X509V2AttributeCertificate> arrayList = new ArrayList<X509V2AttributeCertificate>();
        if (aSN1Set != null) {
            Enumeration enumeration = aSN1Set.getObjects();
            while (enumeration.hasMoreElements()) {
                try {
                    ASN1TaggedObject aSN1TaggedObject;
                    DERObject dERObject = ((DEREncodable)enumeration.nextElement()).getDERObject();
                    if (!(dERObject instanceof ASN1TaggedObject) || (aSN1TaggedObject = (ASN1TaggedObject)dERObject).getTagNo() != 2) continue;
                    arrayList.add(new X509V2AttributeCertificate(ASN1Sequence.getInstance((ASN1TaggedObject)aSN1TaggedObject, (boolean)false).getEncoded()));
                }
                catch (IOException iOException) {
                    throw new CMSException("can't re-encode attribute certificate!", iOException);
                }
            }
        }
        try {
            return X509Store.getInstance((String)("AttributeCertificate/" + string), (X509StoreParameters)new X509CollectionStoreParameters(arrayList), (String)string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException("can't setup the X509Store", illegalArgumentException);
        }
    }

    X509Store createCertificateStore(String string, String string2, ASN1Set aSN1Set) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        ArrayList arrayList = new ArrayList();
        if (aSN1Set != null) {
            this.addCertsFromSet(arrayList, aSN1Set, string2);
        }
        try {
            return X509Store.getInstance((String)("Certificate/" + string), (X509StoreParameters)new X509CollectionStoreParameters(arrayList), (String)string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException("can't setup the X509Store", illegalArgumentException);
        }
    }

    X509Store createCRLsStore(String string, String string2, ASN1Set aSN1Set) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        ArrayList arrayList = new ArrayList();
        if (aSN1Set != null) {
            this.addCRLsFromSet(arrayList, aSN1Set, string2);
        }
        try {
            return X509Store.getInstance((String)("CRL/" + string), (X509StoreParameters)new X509CollectionStoreParameters(arrayList), (String)string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException("can't setup the X509Store", illegalArgumentException);
        }
    }

    CertStore createCertStore(String string, String string2, ASN1Set aSN1Set, ASN1Set aSN1Set2) throws NoSuchProviderException, CMSException, NoSuchAlgorithmException {
        ArrayList arrayList = new ArrayList();
        if (aSN1Set != null) {
            this.addCertsFromSet(arrayList, aSN1Set, string2);
        }
        if (aSN1Set2 != null) {
            this.addCRLsFromSet(arrayList, aSN1Set2, string2);
        }
        try {
            if (string2 != null) {
                return CertStore.getInstance(string, (CertStoreParameters)new CollectionCertStoreParameters(arrayList), string2);
            }
            return CertStore.getInstance(string, new CollectionCertStoreParameters(arrayList));
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("can't setup the CertStore", invalidAlgorithmParameterException);
        }
    }

    private void addCertsFromSet(List list, ASN1Set aSN1Set, String string) throws NoSuchProviderException, CMSException {
        CertificateFactory certificateFactory;
        try {
            certificateFactory = string != null ? CertificateFactory.getInstance("X.509", string) : CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new CMSException("can't get certificate factory.", certificateException);
        }
        Enumeration enumeration = aSN1Set.getObjects();
        while (enumeration.hasMoreElements()) {
            try {
                DERObject dERObject = ((DEREncodable)enumeration.nextElement()).getDERObject();
                if (!(dERObject instanceof ASN1Sequence)) continue;
                list.add(certificateFactory.generateCertificate(new ByteArrayInputStream(dERObject.getEncoded())));
            }
            catch (IOException iOException) {
                throw new CMSException("can't re-encode certificate!", iOException);
            }
            catch (CertificateException certificateException) {
                throw new CMSException("can't re-encode certificate!", certificateException);
            }
        }
    }

    private void addCRLsFromSet(List list, ASN1Set aSN1Set, String string) throws NoSuchProviderException, CMSException {
        CertificateFactory certificateFactory;
        try {
            certificateFactory = string != null ? CertificateFactory.getInstance("X.509", string) : CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new CMSException("can't get certificate factory.", certificateException);
        }
        Enumeration enumeration = aSN1Set.getObjects();
        while (enumeration.hasMoreElements()) {
            try {
                DERObject dERObject = ((DEREncodable)enumeration.nextElement()).getDERObject();
                list.add(certificateFactory.generateCRL(new ByteArrayInputStream(dERObject.getEncoded())));
            }
            catch (IOException iOException) {
                throw new CMSException("can't re-encode CRL!", iOException);
            }
            catch (CRLException cRLException) {
                throw new CMSException("can't re-encode CRL!", cRLException);
            }
        }
    }

    private boolean anyCertHasTypeOther() {
        return false;
    }

    private boolean anyCertHasV1Attribute() {
        return false;
    }

    private boolean anyCertHasV2Attribute() {
        return false;
    }

    private boolean anyCrlHasTypeOther() {
        return false;
    }

    static {
        CMSSignedHelper.addEntries(NISTObjectIdentifiers.dsa_with_sha224, "SHA224", "DSA");
        CMSSignedHelper.addEntries(NISTObjectIdentifiers.dsa_with_sha256, "SHA256", "DSA");
        CMSSignedHelper.addEntries(NISTObjectIdentifiers.dsa_with_sha384, "SHA384", "DSA");
        CMSSignedHelper.addEntries(NISTObjectIdentifiers.dsa_with_sha512, "SHA512", "DSA");
        CMSSignedHelper.addEntries(OIWObjectIdentifiers.dsaWithSHA1, "SHA1", "DSA");
        CMSSignedHelper.addEntries(OIWObjectIdentifiers.md4WithRSA, "MD4", "RSA");
        CMSSignedHelper.addEntries(OIWObjectIdentifiers.md4WithRSAEncryption, "MD4", "RSA");
        CMSSignedHelper.addEntries(OIWObjectIdentifiers.md5WithRSA, "MD5", "RSA");
        CMSSignedHelper.addEntries(OIWObjectIdentifiers.sha1WithRSA, "SHA1", "RSA");
        CMSSignedHelper.addEntries(PKCSObjectIdentifiers.md2WithRSAEncryption, "MD2", "RSA");
        CMSSignedHelper.addEntries(PKCSObjectIdentifiers.md4WithRSAEncryption, "MD4", "RSA");
        CMSSignedHelper.addEntries(PKCSObjectIdentifiers.md5WithRSAEncryption, "MD5", "RSA");
        CMSSignedHelper.addEntries(PKCSObjectIdentifiers.sha1WithRSAEncryption, "SHA1", "RSA");
        CMSSignedHelper.addEntries(PKCSObjectIdentifiers.sha224WithRSAEncryption, "SHA224", "RSA");
        CMSSignedHelper.addEntries(PKCSObjectIdentifiers.sha256WithRSAEncryption, "SHA256", "RSA");
        CMSSignedHelper.addEntries(PKCSObjectIdentifiers.sha384WithRSAEncryption, "SHA384", "RSA");
        CMSSignedHelper.addEntries(PKCSObjectIdentifiers.sha512WithRSAEncryption, "SHA512", "RSA");
        CMSSignedHelper.addEntries(X9ObjectIdentifiers.ecdsa_with_SHA1, "SHA1", "ECDSA");
        CMSSignedHelper.addEntries(X9ObjectIdentifiers.ecdsa_with_SHA224, "SHA224", "ECDSA");
        CMSSignedHelper.addEntries(X9ObjectIdentifiers.ecdsa_with_SHA256, "SHA256", "ECDSA");
        CMSSignedHelper.addEntries(X9ObjectIdentifiers.ecdsa_with_SHA384, "SHA384", "ECDSA");
        CMSSignedHelper.addEntries(X9ObjectIdentifiers.ecdsa_with_SHA512, "SHA512", "ECDSA");
        CMSSignedHelper.addEntries(X9ObjectIdentifiers.id_dsa_with_sha1, "SHA1", "DSA");
        encryptionAlgs.put(X9ObjectIdentifiers.id_dsa.getId(), "DSA");
        encryptionAlgs.put(PKCSObjectIdentifiers.rsaEncryption.getId(), "RSA");
        encryptionAlgs.put("1.3.36.3.3.1", "RSA");
        encryptionAlgs.put(X509ObjectIdentifiers.id_ea_rsa.getId(), "RSA");
        encryptionAlgs.put(CMSSignedDataGenerator.ENCRYPTION_RSA_PSS, "RSAandMGF1");
        encryptionAlgs.put(CryptoProObjectIdentifiers.gostR3410_94.getId(), "GOST3410");
        encryptionAlgs.put(CryptoProObjectIdentifiers.gostR3410_2001.getId(), "ECGOST3410");
        encryptionAlgs.put("1.3.6.1.4.1.5849.1.6.2", "ECGOST3410");
        encryptionAlgs.put("1.3.6.1.4.1.5849.1.1.5", "GOST3410");
        digestAlgs.put(PKCSObjectIdentifiers.md2.getId(), "MD2");
        digestAlgs.put(PKCSObjectIdentifiers.md4.getId(), "MD4");
        digestAlgs.put(PKCSObjectIdentifiers.md5.getId(), "MD5");
        digestAlgs.put(OIWObjectIdentifiers.idSHA1.getId(), "SHA1");
        digestAlgs.put(NISTObjectIdentifiers.id_sha224.getId(), "SHA224");
        digestAlgs.put(NISTObjectIdentifiers.id_sha256.getId(), "SHA256");
        digestAlgs.put(NISTObjectIdentifiers.id_sha384.getId(), "SHA384");
        digestAlgs.put(NISTObjectIdentifiers.id_sha512.getId(), "SHA512");
        digestAlgs.put(TeleTrusTObjectIdentifiers.ripemd128.getId(), "RIPEMD128");
        digestAlgs.put(TeleTrusTObjectIdentifiers.ripemd160.getId(), "RIPEMD160");
        digestAlgs.put(TeleTrusTObjectIdentifiers.ripemd256.getId(), "RIPEMD256");
        digestAlgs.put(CryptoProObjectIdentifiers.gostR3411.getId(), "GOST3411");
        digestAlgs.put("1.3.6.1.4.1.5849.1.2.1", "GOST3411");
        digestAliases.put("SHA1", new String[]{"SHA-1"});
        digestAliases.put("SHA224", new String[]{"SHA-224"});
        digestAliases.put("SHA256", new String[]{"SHA-256"});
        digestAliases.put("SHA384", new String[]{"SHA-384"});
        digestAliases.put("SHA512", new String[]{"SHA-512"});
    }
}

