/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.ProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;

public class KeyTransRecipientInformation
extends RecipientInformation {
    private KeyTransRecipientInfo _info;

    public KeyTransRecipientInformation(KeyTransRecipientInfo keyTransRecipientInfo, AlgorithmIdentifier algorithmIdentifier, InputStream inputStream) {
        super(algorithmIdentifier, AlgorithmIdentifier.getInstance((Object)keyTransRecipientInfo.getKeyEncryptionAlgorithm()), inputStream);
        this._info = keyTransRecipientInfo;
        this._rid = new RecipientId();
        RecipientIdentifier recipientIdentifier = keyTransRecipientInfo.getRecipientIdentifier();
        try {
            if (recipientIdentifier.isTagged()) {
                ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance((Object)recipientIdentifier.getId());
                this._rid.setSubjectKeyIdentifier(aSN1OctetString.getOctets());
            } else {
                IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance((Object)recipientIdentifier.getId());
                this._rid.setIssuer(issuerAndSerialNumber.getName().getEncoded());
                this._rid.setSerialNumber(issuerAndSerialNumber.getSerialNumber().getValue());
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid rid in KeyTransRecipientInformation");
        }
    }

    private String getExchangeEncryptionAlgorithmName(DERObjectIdentifier dERObjectIdentifier) {
        if (PKCSObjectIdentifiers.rsaEncryption.equals((Object)dERObjectIdentifier)) {
            return "RSA/ECB/PKCS1Padding";
        }
        return dERObjectIdentifier.getId();
    }

    @Override
    public CMSTypedStream getContentStream(Key key, String string) throws CMSException, NoSuchProviderException {
        byte[] byArray = this._info.getEncryptedKey().getOctets();
        String string2 = this.getExchangeEncryptionAlgorithmName(this._keyEncAlg.getObjectId());
        String string3 = CMSEnvelopedHelper.INSTANCE.getSymmetricCipherName(this._encAlg.getObjectId().getId());
        try {
            Key key2;
            Cipher cipher = CMSEnvelopedHelper.INSTANCE.getSymmetricCipher(string2, string);
            try {
                cipher.init(4, key);
                key2 = cipher.unwrap(byArray, string3, 3);
            }
            catch (GeneralSecurityException generalSecurityException) {
                cipher.init(2, key);
                key2 = new SecretKeySpec(cipher.doFinal(byArray), string3);
            }
            catch (IllegalStateException illegalStateException) {
                cipher.init(2, key);
                key2 = new SecretKeySpec(cipher.doFinal(byArray), string3);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                cipher.init(2, key);
                key2 = new SecretKeySpec(cipher.doFinal(byArray), string3);
            }
            catch (ProviderException providerException) {
                cipher.init(2, key);
                key2 = new SecretKeySpec(cipher.doFinal(byArray), string3);
            }
            return this.getContentFromSessionKey(key2, string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find algorithm.", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new CMSException("illegal blocksize in message.", illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new CMSException("bad padding in message.", badPaddingException);
        }
    }
}

