/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.group.PEX_P07_ASSOCIATED_RX_ADMIN;
import ca.uhn.hl7v2.model.v23.group.PEX_P07_ASSOCIATED_RX_ORDER;
import ca.uhn.hl7v2.model.v23.segment.NK1;
import ca.uhn.hl7v2.model.v23.segment.OBX;
import ca.uhn.hl7v2.model.v23.segment.PRB;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class PEX_P07_ASSOCIATED_PERSON
extends AbstractGroup {
    public PEX_P07_ASSOCIATED_PERSON(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NK1.class, true, false);
            this.add(PEX_P07_ASSOCIATED_RX_ORDER.class, false, false);
            this.add(PEX_P07_ASSOCIATED_RX_ADMIN.class, false, true);
            this.add(PRB.class, false, true);
            this.add(OBX.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating PEX_P07_ASSOCIATED_PERSON - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public NK1 getNK1() {
        NK1 ret = null;
        try {
            ret = (NK1)this.get("NK1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PEX_P07_ASSOCIATED_RX_ORDER getASSOCIATED_RX_ORDER() {
        PEX_P07_ASSOCIATED_RX_ORDER ret = null;
        try {
            ret = (PEX_P07_ASSOCIATED_RX_ORDER)this.get("ASSOCIATED_RX_ORDER");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PEX_P07_ASSOCIATED_RX_ADMIN getASSOCIATED_RX_ADMIN() {
        PEX_P07_ASSOCIATED_RX_ADMIN ret = null;
        try {
            ret = (PEX_P07_ASSOCIATED_RX_ADMIN)this.get("ASSOCIATED_RX_ADMIN");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PEX_P07_ASSOCIATED_RX_ADMIN getASSOCIATED_RX_ADMIN(int rep) {
        PEX_P07_ASSOCIATED_RX_ADMIN ret = null;
        try {
            ret = (PEX_P07_ASSOCIATED_RX_ADMIN)this.get("ASSOCIATED_RX_ADMIN", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getASSOCIATED_RX_ADMINReps() {
        int reps = -1;
        try {
            reps = this.getAll("ASSOCIATED_RX_ADMIN").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertASSOCIATED_RX_ADMIN(PEX_P07_ASSOCIATED_RX_ADMIN structure, int rep) throws HL7Exception {
        super.insertRepetition("ASSOCIATED_RX_ADMIN", (Structure)structure, rep);
    }

    public PEX_P07_ASSOCIATED_RX_ADMIN insertASSOCIATED_RX_ADMIN(int rep) throws HL7Exception {
        return (PEX_P07_ASSOCIATED_RX_ADMIN)super.insertRepetition("ASSOCIATED_RX_ADMIN", rep);
    }

    public PEX_P07_ASSOCIATED_RX_ADMIN removeASSOCIATED_RX_ADMIN(int rep) throws HL7Exception {
        return (PEX_P07_ASSOCIATED_RX_ADMIN)super.removeRepetition("ASSOCIATED_RX_ADMIN", rep);
    }

    public PRB getPRB() {
        PRB ret = null;
        try {
            ret = (PRB)this.get("PRB");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PRB getPRB(int rep) {
        PRB ret = null;
        try {
            ret = (PRB)this.get("PRB", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPRBReps() {
        int reps = -1;
        try {
            reps = this.getAll("PRB").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPRB(PRB structure, int rep) throws HL7Exception {
        super.insertRepetition("PRB", (Structure)structure, rep);
    }

    public PRB insertPRB(int rep) throws HL7Exception {
        return (PRB)super.insertRepetition("PRB", rep);
    }

    public PRB removePRB(int rep) throws HL7Exception {
        return (PRB)super.removeRepetition("PRB", rep);
    }

    public OBX getOBX() {
        OBX ret = null;
        try {
            ret = (OBX)this.get("OBX");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OBX getOBX(int rep) {
        OBX ret = null;
        try {
            ret = (OBX)this.get("OBX", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getOBXReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBX").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", (Structure)structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }
}

