/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v231.group.SQR_S25_PIDPV1PV2DG1;
import ca.uhn.hl7v2.model.v231.group.SQR_S25_RGSAISNTEAIGNTEAIPNTEAILNTE;
import ca.uhn.hl7v2.model.v231.segment.NTE;
import ca.uhn.hl7v2.model.v231.segment.SCH;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class SQR_S25_SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE
extends AbstractGroup {
    public SQR_S25_SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SCH.class, true, false);
            this.add(NTE.class, false, true);
            this.add(SQR_S25_PIDPV1PV2DG1.class, false, false);
            this.add(SQR_S25_RGSAISNTEAIGNTEAIPNTEAILNTE.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating SQR_S25_SCHNTEPIDPV1PV2DG1RGSAISNTEAIGNTEAIPNTEAILNTE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public SCH getSCH() {
        SCH ret = null;
        try {
            ret = (SCH)this.get("SCH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public SQR_S25_PIDPV1PV2DG1 getPIDPV1PV2DG1() {
        SQR_S25_PIDPV1PV2DG1 ret = null;
        try {
            ret = (SQR_S25_PIDPV1PV2DG1)this.get("PIDPV1PV2DG1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SQR_S25_RGSAISNTEAIGNTEAIPNTEAILNTE getRGSAISNTEAIGNTEAIPNTEAILNTE() {
        SQR_S25_RGSAISNTEAIGNTEAIPNTEAILNTE ret = null;
        try {
            ret = (SQR_S25_RGSAISNTEAIGNTEAIPNTEAILNTE)this.get("RGSAISNTEAIGNTEAIPNTEAILNTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SQR_S25_RGSAISNTEAIGNTEAIPNTEAILNTE getRGSAISNTEAIGNTEAIPNTEAILNTE(int rep) {
        SQR_S25_RGSAISNTEAIGNTEAIPNTEAILNTE ret = null;
        try {
            ret = (SQR_S25_RGSAISNTEAIGNTEAIPNTEAILNTE)this.get("RGSAISNTEAIGNTEAIPNTEAILNTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getRGSAISNTEAIGNTEAIPNTEAILNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("RGSAISNTEAIGNTEAIPNTEAILNTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertRGSAISNTEAIGNTEAIPNTEAILNTE(SQR_S25_RGSAISNTEAIGNTEAIPNTEAILNTE structure, int rep) throws HL7Exception {
        super.insertRepetition("RGSAISNTEAIGNTEAIPNTEAILNTE", (Structure)structure, rep);
    }

    public SQR_S25_RGSAISNTEAIGNTEAIPNTEAILNTE insertRGSAISNTEAIGNTEAIPNTEAILNTE(int rep) throws HL7Exception {
        return (SQR_S25_RGSAISNTEAIGNTEAIPNTEAILNTE)super.insertRepetition("RGSAISNTEAIGNTEAIPNTEAILNTE", rep);
    }

    public SQR_S25_RGSAISNTEAIGNTEAIPNTEAILNTE removeRGSAISNTEAIGNTEAIPNTEAILNTE(int rep) throws HL7Exception {
        return (SQR_S25_RGSAISNTEAIGNTEAIPNTEAILNTE)super.removeRepetition("RGSAISNTEAIGNTEAIPNTEAILNTE", rep);
    }
}

