/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v231.group.SRM_S01_PIDPV1PV2OBXDG1;
import ca.uhn.hl7v2.model.v231.group.SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE;
import ca.uhn.hl7v2.model.v231.segment.APR;
import ca.uhn.hl7v2.model.v231.segment.ARQ;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.model.v231.segment.NTE;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class SRM_S01
extends AbstractMessage {
    public SRM_S01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    public SRM_S01() {
        super((ModelClassFactory)new DefaultModelClassFactory());
        this.init((ModelClassFactory)new DefaultModelClassFactory());
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(ARQ.class, true, false);
            this.add(APR.class, false, false);
            this.add(NTE.class, false, true);
            this.add(SRM_S01_PIDPV1PV2OBXDG1.class, false, true);
            this.add(SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating SRM_S01 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ARQ getARQ() {
        ARQ ret = null;
        try {
            ret = (ARQ)this.get("ARQ");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public APR getAPR() {
        APR ret = null;
        try {
            ret = (APR)this.get("APR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public SRM_S01_PIDPV1PV2OBXDG1 getPIDPV1PV2OBXDG1() {
        SRM_S01_PIDPV1PV2OBXDG1 ret = null;
        try {
            ret = (SRM_S01_PIDPV1PV2OBXDG1)this.get("PIDPV1PV2OBXDG1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SRM_S01_PIDPV1PV2OBXDG1 getPIDPV1PV2OBXDG1(int rep) {
        SRM_S01_PIDPV1PV2OBXDG1 ret = null;
        try {
            ret = (SRM_S01_PIDPV1PV2OBXDG1)this.get("PIDPV1PV2OBXDG1", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPIDPV1PV2OBXDG1Reps() {
        int reps = -1;
        try {
            reps = this.getAll("PIDPV1PV2OBXDG1").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPIDPV1PV2OBXDG1(SRM_S01_PIDPV1PV2OBXDG1 structure, int rep) throws HL7Exception {
        super.insertRepetition("PIDPV1PV2OBXDG1", (Structure)structure, rep);
    }

    public SRM_S01_PIDPV1PV2OBXDG1 insertPIDPV1PV2OBXDG1(int rep) throws HL7Exception {
        return (SRM_S01_PIDPV1PV2OBXDG1)super.insertRepetition("PIDPV1PV2OBXDG1", rep);
    }

    public SRM_S01_PIDPV1PV2OBXDG1 removePIDPV1PV2OBXDG1(int rep) throws HL7Exception {
        return (SRM_S01_PIDPV1PV2OBXDG1)super.removeRepetition("PIDPV1PV2OBXDG1", rep);
    }

    public SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE getRGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE() {
        SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE ret = null;
        try {
            ret = (SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE)this.get("RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE getRGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE(int rep) {
        SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE ret = null;
        try {
            ret = (SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE)this.get("RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getRGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertRGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE(SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE structure, int rep) throws HL7Exception {
        super.insertRepetition("RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE", (Structure)structure, rep);
    }

    public SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE insertRGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE(int rep) throws HL7Exception {
        return (SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE)super.insertRepetition("RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE", rep);
    }

    public SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE removeRGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE(int rep) throws HL7Exception {
        return (SRM_S01_RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE)super.removeRepetition("RGSAISAPRNTEAIGAPRNTEAILAPRNTEAIPAPRNTE", rep);
    }
}

