/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.discrepancy;

import umontreal.ssj.discrepancy.Discrepancy;
import umontreal.ssj.hups.PointSet;

public class DiscL2Symmetric
extends Discrepancy {
    @Override
    public double compute(double[][] points, int n, int s, double[] gamma) {
        return this.compute(points, n, s);
    }

    public DiscL2Symmetric(double[][] points, int n, int s) {
        super(points, n, s);
    }

    public DiscL2Symmetric(int n, int s) {
        super(null, n, s);
    }

    public DiscL2Symmetric(PointSet set) {
        super(set);
    }

    public DiscL2Symmetric() {
    }

    @Override
    public double compute(double[][] points, int n, int s) {
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            double prod = 1.0;
            for (int j = 0; j < s; ++j) {
                double u = 0.5 - points[i][j];
                prod *= 1.5 - 2.0 * u * u;
            }
            sum += prod;
        }
        double disc = -2.0 * sum / (double)n;
        sum = n;
        double sum2 = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                double prod = 1.0;
                for (int k = 0; k < s; ++k) {
                    prod *= 1.0 - Math.abs(points[i][k] - points[j][k]);
                }
                sum2 += prod;
            }
        }
        disc += (sum + 2.0 * sum2) * Math.pow(2.0, s) / (double)((long)n * (long)n);
        if ((disc += Math.pow(1.3333333333333333, s)) < 0.0) {
            return -1.0;
        }
        return Math.sqrt(disc);
    }

    @Override
    public double compute(double[] T, int n) {
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            sum += T[i] * (1.0 - T[i]);
        }
        double disc = -4.0 * sum / (double)n;
        sum = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                sum += Math.abs(T[i] - T[j]);
            }
        }
        disc -= 4.0 * sum / (double)((long)n * (long)n);
        if ((disc += 1.3333333333333333) < 0.0) {
            return 0.0;
        }
        return Math.sqrt(disc);
    }
}

