/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.discrepancy;

import umontreal.ssj.discrepancy.DiscShift1;
import umontreal.ssj.hups.Rank1Lattice;

public class DiscShift1Lattice
extends DiscShift1 {
    public DiscShift1Lattice(double[][] points, int n, int s) {
        super(points, n, s);
    }

    public DiscShift1Lattice(double[][] points, int n, int s, double[] gamma) {
        super(points, n, s, gamma);
    }

    public DiscShift1Lattice(int n, int s, double[] gamma) {
        super(n, s, gamma);
    }

    public DiscShift1Lattice(Rank1Lattice set) {
        super(set);
    }

    public DiscShift1Lattice() {
    }

    @Override
    public double compute(double[][] points, int n, int s) {
        DiscShift1Lattice.setONES(s);
        return this.compute(points, n, s, ONES);
    }

    @Override
    public double compute(double[][] points, int n, int s, double[] gamma) {
        double[] C1 = new double[s];
        DiscShift1Lattice.setC(C1, gamma, s);
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            double prod = 1.0;
            for (int r = 0; r < s; ++r) {
                double u = points[i][r];
                double pol1 = u * (u - 1.0) + 0.16666666666666666;
                prod *= 1.0 + C1[r] * pol1;
            }
            sum += prod;
        }
        double disc = sum / (double)n - 1.0;
        if (disc < 0.0) {
            return -1.0;
        }
        return Math.sqrt(disc);
    }

    @Override
    public double compute(double[] T, int n) {
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            double h = T[i];
            double pol1 = h * (h - 1.0) + 0.16666666666666666;
            sum += pol1;
        }
        double disc = sum / (double)n;
        if (disc < 0.0) {
            return -1.0;
        }
        return Math.sqrt(disc);
    }
}

