/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.hups;

import umontreal.ssj.hups.PointSet;
import umontreal.ssj.hups.RadicalInverse;

public class HammersleyPointSet
extends PointSet {
    private int[] base;
    private int[][] permutation;
    private boolean permuted;

    public HammersleyPointSet(int n, int dim) {
        if (n < 0 || dim < 1) {
            throw new IllegalArgumentException("Hammersley point sets must have positive dimension and n >= 0");
        }
        this.numPoints = n;
        this.dim = dim;
        if (dim > 1) {
            this.base = RadicalInverse.getPrimes(dim - 1);
        }
    }

    public void addFaurePermutations() {
        if (this.dim > 1) {
            this.permutation = new int[this.dim][];
            for (int i = 0; i < this.dim - 1; ++i) {
                this.permutation[i] = new int[this.base[i]];
                RadicalInverse.getFaurePermutation(this.base[i], this.permutation[i]);
            }
        }
        this.permuted = true;
    }

    public void ErasePermutations() {
        this.permuted = false;
        this.permutation = null;
    }

    @Override
    public double getCoordinate(int i, int j) {
        if (j == 0) {
            return (double)i / (double)this.numPoints;
        }
        if (this.permuted) {
            return RadicalInverse.permutedRadicalInverse(this.base[j - 1], this.permutation[j - 1], i);
        }
        return RadicalInverse.radicalInverse(this.base[j - 1], i);
    }
}

