/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.mcqmctools.anova;

import umontreal.ssj.hups.PointSetIterator;
import umontreal.ssj.hups.RQMCPointSet;
import umontreal.ssj.mcqmctools.MonteCarloModel;
import umontreal.ssj.mcqmctools.MonteCarloModelDouble;
import umontreal.ssj.mcqmctools.anova.ObservationCollector;
import umontreal.ssj.mcqmctools.anova.RandomSampler;
import umontreal.ssj.rng.RandomStream;
import umontreal.ssj.stat.Tally;

public class RQMCSampler
implements RandomSampler {
    protected RQMCPointSet points;

    public RQMCSampler(RQMCPointSet points, RandomStream stream) {
        this.points = points;
        this.setStream(stream);
    }

    public RQMCSampler(RQMCPointSet points) {
        this.points = points;
    }

    public RQMCPointSet getRQMCPointSet() {
        return this.points;
    }

    @Override
    public RandomStream getStream() {
        return this.points.getRandomization().getStream();
    }

    @Override
    public void setStream(RandomStream stream) {
        this.points.getRandomization().setStream(stream);
    }

    @Override
    public int getNumSimulationsPerSample() {
        return 1;
    }

    @Override
    public int getNumSamples() {
        return this.points.getPointSet().getNumPoints();
    }

    @Override
    public <E> void simulateRuns(MonteCarloModel<? extends E> model, ObservationCollector<E> collector) {
        this.randomize();
        PointSetIterator it = this.points.iterator();
        while (it.hasNextPoint()) {
            model.simulate(it);
            collector.observe(model.getPerformance());
            it.resetToNextPoint();
        }
    }

    @Override
    public void simulateRuns(MonteCarloModelDouble model, Tally collector) {
        this.randomize();
        PointSetIterator it = this.points.iterator();
        while (it.hasNextPoint()) {
            model.simulate(it);
            collector.add(model.getPerformance());
            it.resetToNextPoint();
        }
    }

    public String toString() {
        return "RQMC Sampler [points=" + this.points.getPointSet().getNumPoints() + "] [dimension=" + this.points.getPointSet().getDimension() + "] [pointset=" + this.points.getPointSet().getClass().getSimpleName() + "] [randomization=" + this.points.getRandomization().getClass().getSimpleName() + "]";
    }

    protected void randomize() {
        this.points.randomize();
        if (this.getStream() instanceof PointSetIterator) {
            ((PointSetIterator)this.getStream()).resetToNextPoint();
        }
    }
}

