/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.probdist;

import umontreal.ssj.functions.MathFunction;
import umontreal.ssj.probdist.DiscreteDistributionInt;
import umontreal.ssj.probdist.NormalDist;
import umontreal.ssj.probdist.PoissonDist;
import umontreal.ssj.util.Num;
import umontreal.ssj.util.RootFinder;

public class BinomialDist
extends DiscreteDistributionInt {
    private int n;
    private double p;
    private double q;
    private static final double EPS2 = 100.0 * EPSILON;
    public static double MAXN = 100000.0;

    public BinomialDist(int n, double p) {
        this.setBinomial(n, p);
    }

    @Override
    public double prob(int x) {
        if (this.n == 0) {
            return 1.0;
        }
        if (x < 0 || x > this.n) {
            return 0.0;
        }
        if (this.p == 0.0) {
            if (x > 0) {
                return 0.0;
            }
            return 1.0;
        }
        if (this.q == 0.0) {
            if (x < this.n) {
                return 0.0;
            }
            return 1.0;
        }
        if (this.pdf == null) {
            return BinomialDist.prob(this.n, this.p, this.q, x);
        }
        if (x > this.xmax || x < this.xmin) {
            return BinomialDist.prob(this.n, this.p, this.q, x);
        }
        return this.pdf[x - this.xmin];
    }

    @Override
    public double cdf(int x) {
        if (this.n == 0) {
            return 1.0;
        }
        if (x < 0) {
            return 0.0;
        }
        if (x >= this.n) {
            return 1.0;
        }
        if (this.p == 0.0) {
            return 1.0;
        }
        if (this.p == 1.0) {
            return 0.0;
        }
        if (this.cdf != null) {
            if (x >= this.xmax) {
                return 1.0;
            }
            if (x < this.xmin) {
                double term;
                int RMAX = 20;
                double Sum = term = this.prob(x);
                double z = (1.0 - this.p) / this.p;
                int i = x;
                while (i > 0 && i >= x - 20) {
                    Sum += (term *= z * (double)(--i) / (double)(this.n - i + 1));
                }
                return Sum;
            }
            if (x <= this.xmed) {
                return this.cdf[x - this.xmin];
            }
            return 1.0 - this.cdf[x + 1 - this.xmin];
        }
        return BinomialDist.cdf(this.n, this.p, x);
    }

    @Override
    public double barF(int x) {
        if (this.n == 0) {
            return 1.0;
        }
        if (x < 1) {
            return 1.0;
        }
        if (x > this.n) {
            return 0.0;
        }
        if (this.p == 0.0) {
            return 0.0;
        }
        if (this.p == 1.0) {
            return 1.0;
        }
        if (this.cdf != null) {
            if (x > this.xmax) {
                double term;
                double q = 1.0 - this.p;
                double sum = term = this.prob(x);
                double z = this.p / q;
                int IMAX = 20;
                for (int i = x; i < this.n && i < x + 20; ++i) {
                    term = term * z * (double)(this.n - i) / (double)(i + 1);
                    sum += term;
                }
                return sum;
            }
            if (x <= this.xmin) {
                return 1.0;
            }
            if (x > this.xmed) {
                return this.cdf[x - this.xmin];
            }
            return 1.0 - this.cdf[x - 1 - this.xmin];
        }
        return 1.0 - BinomialDist.cdf(this.n, this.p, x - 1);
    }

    @Override
    public int inverseFInt(double u) {
        if (this.cdf == null || u <= EPS2) {
            return BinomialDist.inverseF(this.n, this.p, u);
        }
        return super.inverseFInt(u);
    }

    @Override
    public double getMean() {
        return BinomialDist.getMean(this.n, this.p);
    }

    @Override
    public double getVariance() {
        return BinomialDist.getVariance(this.n, this.p);
    }

    @Override
    public double getStandardDeviation() {
        return BinomialDist.getStandardDeviation(this.n, this.p);
    }

    public static double prob(int n, double p, int x) {
        return BinomialDist.prob(n, p, 1.0 - p, x);
    }

    public static double prob(int n, double p, double q, int x) {
        double Res;
        int SLIM = 50;
        double MAXEXP = 709.0895657128241;
        double MINEXP = -708.3964185322641;
        int signe = 1;
        if (n < 0) {
            throw new IllegalArgumentException("n < 0");
        }
        if (n == 0) {
            return 1.0;
        }
        if (x < 0 || x > n) {
            return 0.0;
        }
        if (x > n / 2) {
            x = n - x;
            Res = p;
            p = q;
            q = Res;
        }
        if (p < 0.0) {
            p = -p;
            if ((x & 1) != 0) {
                signe *= -1;
            }
        }
        if (q < 0.0) {
            q = -q;
            if ((n - x & 1) != 0) {
                signe *= -1;
            }
        }
        if (n <= 50) {
            Res = Math.pow(p, x) * Num.combination(n, x) * Math.pow(q, n - x);
            return (double)signe * Res;
        }
        Res = (double)x * Math.log(p) + (double)(n - x) * Math.log(q) + Num.lnFactorial(n) - Num.lnFactorial(n - x) - Num.lnFactorial(x);
        if (Res >= 709.0895657128241) {
            throw new IllegalArgumentException("term overflow");
        }
        if (Res < -708.3964185322641) {
            return 0.0;
        }
        return (double)signe * Math.exp(Res);
    }

    public static double cdf(int n, double p, int x) {
        int NLIM1 = 10000;
        double VARLIM = 50.0;
        double q = 1.0 - p;
        boolean flag = false;
        if (p < 0.0 | p > 1.0) {
            throw new IllegalArgumentException("p not in [0,1]");
        }
        if (n < 0) {
            throw new IllegalArgumentException("n < 0");
        }
        if (n == 0) {
            return 1.0;
        }
        if (x < 0) {
            return 0.0;
        }
        if (x >= n) {
            return 1.0;
        }
        if (p <= 0.0) {
            return 1.0;
        }
        if (p >= 1.0) {
            return 0.0;
        }
        if (n < 10000) {
            double termmid;
            int RMAX = 20;
            int mid = (int)((double)(n + 1) * p);
            if (mid > x) {
                mid = x;
            }
            double term = termmid = BinomialDist.prob(n, p, 1.0 - p, mid);
            double sum = termmid;
            double z = q / p;
            int i = mid;
            while (term >= EPSILON || i >= mid - 20) {
                sum += (term *= z * (double)i / (double)(n - i + 1));
                if (--i != 0) continue;
            }
            z = p / q;
            term = termmid;
            for (i = mid; i < x && !((term *= z * (double)(n - i) / (double)(i + 1)) < EPSILON); ++i) {
                sum += term;
            }
            if (sum >= 1.0) {
                return 1.0;
            }
            return sum;
        }
        if (p > 0.5 || p == 0.5 && x > n / 2) {
            p = q;
            q = 1.0 - p;
            flag = true;
            x = n - x - 1;
        }
        if ((double)n * p * q > 50.0) {
            double term = Math.pow((double)(x + 1) * q / ((double)(n - x) * p), 0.3333333333333333);
            double y = term * (9.0 - 1.0 / (double)(x + 1)) - 9.0 + 1.0 / (double)(n - x);
            double z = 3.0 * Math.sqrt(term * term / (double)(x + 1) + 1.0 / (double)(n - x));
            y /= z;
            if (flag) {
                return NormalDist.barF01(y);
            }
            return NormalDist.cdf01(y);
        }
        double y = (2.0 * (double)n - (double)x) * p / (2.0 - p);
        double t = 2.0 * (double)n - (double)x;
        double z = (2.0 * y * y - (double)x * y - (double)x * (double)x - 2.0 * (double)x) / (6.0 * t * t);
        z = y / (1.0 - z);
        if (flag) {
            return PoissonDist.barF(z, x - 1);
        }
        return PoissonDist.cdf(z, x);
    }

    public static double barF(int n, double p, int x) {
        return 1.0 - BinomialDist.cdf(n, p, x - 1);
    }

    public static int inverseF(int n, double p, double u) {
        double sum;
        int i;
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (u <= BinomialDist.prob(n, p, 0)) {
            return 0;
        }
        if (u > 1.0 - BinomialDist.prob(n, p, n) || u >= 1.0) {
            return n;
        }
        int NLIM1 = 10000;
        double q = 1.0 - p;
        if (n < 10000) {
            double termmid;
            int i2 = (int)((double)(n + 1) * p);
            if (i2 > n) {
                i2 = n;
            }
            double term = BinomialDist.prob(n, p, i2);
            while (term >= u && term > Double.MIN_NORMAL) {
                term = BinomialDist.prob(n, p, i2 /= 2);
            }
            double z = q / p;
            if (term <= Double.MIN_NORMAL) {
                term = BinomialDist.prob(n, p, i2 *= 2);
                while (term >= u && term > Double.MIN_NORMAL) {
                    term *= z * (double)i2 / (double)(n - i2 + 1);
                    --i2;
                }
            }
            int mid = i2;
            double sum2 = termmid = (term = BinomialDist.prob(n, p, i2));
            z = q / p;
            for (i2 = mid; i2 > 0 && !((term *= z * (double)i2 / (double)(n - i2 + 1)) < EPSILON); --i2) {
                sum2 += term;
            }
            i2 = mid;
            term = termmid;
            if (sum2 >= u) {
                while (sum2 >= u) {
                    z = q / p;
                    sum2 -= term;
                    term *= z * (double)i2 / (double)(n - i2 + 1);
                    --i2;
                }
                return i2 + 1;
            }
            double prev = -1.0;
            while (sum2 < u && sum2 > prev) {
                z = p / q;
                prev = sum2;
                sum2 += (term *= z * (double)(n - i2) / (double)(i2 + 1));
                ++i2;
            }
            return i2;
        }
        for (i = 0; i <= n && !((sum = BinomialDist.cdf(n, p, i)) >= u); ++i) {
        }
        return i;
    }

    public static double[] getMLE(int[] x, int m) {
        int i;
        if (m <= 1) {
            throw new UnsupportedOperationException(" m < 2");
        }
        int r = 0;
        double mean = 0.0;
        for (i = 0; i < m; ++i) {
            mean += (double)x[i];
            if (x[i] <= r) continue;
            r = x[i];
        }
        mean /= (double)m;
        double sum = 0.0;
        for (i = 0; i < m; ++i) {
            sum += ((double)x[i] - mean) * ((double)x[i] - mean);
        }
        double var = sum / (double)m;
        if (mean <= var) {
            throw new UnsupportedOperationException("mean <= variance");
        }
        int[] f = new int[r];
        for (int j = 0; j < r; ++j) {
            f[j] = 0;
            for (i = 0; i < m; ++i) {
                if (x[i] <= j) continue;
                int n = j;
                f[n] = f[n] + 1;
            }
        }
        double p = 1.0 - var / mean;
        double rup = (int)(5.0 * mean / p);
        if (rup < 1.0) {
            rup = 1.0;
        }
        Function fct = new Function(m, mean, r, f);
        double[] parameters = new double[2];
        parameters[0] = (int)RootFinder.brentDekker(r - 1, rup, fct, 1.0E-5);
        if (parameters[0] < (double)r) {
            parameters[0] = r;
        }
        parameters[1] = mean / parameters[0];
        return parameters;
    }

    public static BinomialDist getInstanceFromMLE(int[] x, int m) {
        double[] parameters = new double[2];
        parameters = BinomialDist.getMLE(x, m);
        return new BinomialDist((int)parameters[0], parameters[1]);
    }

    public static double[] getMLE(int[] x, int m, int n) {
        if (m <= 0) {
            throw new IllegalArgumentException("m <= 0");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double[] parameters = new double[1];
        double mean = 0.0;
        for (int i = 0; i < m; ++i) {
            mean += (double)x[i];
        }
        parameters[0] = (mean /= (double)m) / (double)n;
        return parameters;
    }

    public static BinomialDist getInstanceFromMLE(int[] x, int m, int n) {
        double[] parameters = new double[1];
        parameters = BinomialDist.getMLE(x, m, n);
        return new BinomialDist(n, parameters[0]);
    }

    public static double getMean(int n, double p) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p not in range (0, 1)");
        }
        return (double)n * p;
    }

    public static double getVariance(int n, double p) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p not in range (0, 1)");
        }
        return (double)n * p * (1.0 - p);
    }

    public static double getStandardDeviation(int n, double p) {
        return Math.sqrt(BinomialDist.getVariance(n, p));
    }

    private void setBinomial(int n, double p) {
        int i;
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p not in range (0, 1)");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        this.supportA = 0;
        this.supportB = n;
        double q = 1.0 - p;
        double EPS = DiscreteDistributionInt.EPSILON * 1.0E-6;
        this.n = n;
        this.p = p;
        this.q = q;
        double z = 0.0;
        if ((double)n > MAXN) {
            this.pdf = null;
            this.cdf = null;
            return;
        }
        double[] P = new double[1 + n];
        double[] F = new double[1 + n];
        int mid = (int)((double)(n + 1) * Math.abs(p) / (Math.abs(p) + Math.abs(q)));
        if (mid > n) {
            mid = n;
        }
        P[mid] = BinomialDist.prob(n, p, q, mid);
        if (p != 0.0 || p != -0.0) {
            z = q / p;
        }
        for (i = mid; i > 0 && Math.abs(P[i]) > EPS; --i) {
            P[i - 1] = P[i] * z * (double)i / (double)(n - i + 1);
        }
        int imin = i;
        if (q != 0.0 || q != -0.0) {
            z = p / q;
        }
        for (i = mid; i < n && Math.abs(P[i]) > EPS; ++i) {
            P[i + 1] = P[i] * z * (double)(n - i) / (double)(i + 1);
        }
        int imax = i;
        F[imin] = P[imin];
        i = imin;
        while (i < n && F[i] < 0.5) {
            F[++i] = F[i - 1] + P[i];
        }
        this.xmed = i;
        F[imax] = P[imax];
        for (i = imax - 1; i > this.xmed; --i) {
            F[i] = P[i] + F[i + 1];
        }
        for (i = imin; i < this.xmed && F[i] < DiscreteDistributionInt.EPSILON; ++i) {
        }
        this.xmin = imin = i;
        for (i = imax; i > this.xmed && F[i] < DiscreteDistributionInt.EPSILON; --i) {
        }
        this.xmax = imax = i;
        this.pdf = new double[imax + 1 - imin];
        this.cdf = new double[imax + 1 - imin];
        System.arraycopy(P, imin, this.pdf, 0, imax + 1 - imin);
        System.arraycopy(F, imin, this.cdf, 0, imax + 1 - imin);
    }

    public int getN() {
        return this.n;
    }

    public double getP() {
        return this.p;
    }

    @Override
    public double[] getParams() {
        double[] retour = new double[]{this.n, this.p};
        return retour;
    }

    public void setParams(int n, double p) {
        this.setBinomial(n, p);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : n = " + this.n + ", p = " + this.p;
    }

    private static class Function
    implements MathFunction {
        protected int m;
        protected int R;
        protected double mean;
        protected int[] f;

        public Function(int m, double mean, int R, int[] f) {
            this.m = m;
            this.mean = mean;
            this.R = R;
            this.f = new int[f.length];
            System.arraycopy(f, 0, this.f, 0, f.length);
        }

        @Override
        public double evaluate(double x) {
            if (x < (double)this.R) {
                return 1.0E100;
            }
            double sum = 0.0;
            for (int j = 0; j < this.R; ++j) {
                sum += (double)this.f[j] / (x - (double)j);
            }
            return sum + (double)this.m * Math.log1p(-this.mean / x);
        }
    }
}

