/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.probdist;

import umontreal.ssj.probdist.ContinuousDistribution;
import umontreal.ssj.util.Num;

public class NormalDist
extends ContinuousDistribution {
    protected double mu;
    protected double sigma;
    protected static final double RAC2PI = 2.5066282746310007;
    private static final double[] AbarF = new double[]{0.6101430819232004, -0.4348412727125775, 0.1763511936436055, -0.06071079560924941, 0.017712068995694115, -0.004321119385567294, 8.542166768870987E-4, -1.2715509060916275E-4, 1.1248167243671189E-5, 3.1306388542182096E-7, -2.70988068537762E-7, 3.073762270140769E-8, 2.515620384817623E-9, -1.0289299213203192E-9, 2.994405211994994E-11, 2.6051789687266936E-11, -2.6348399241719693E-12, -6.434045098906365E-13, 1.1245740180166345E-13, 1.7281533389986097E-14, -4.2641016949424E-15, -5.4537197788E-16, 1.5869760776E-16, 2.08998378E-17, -5.9E-18};
    private static final int COEFFMAX = 24;
    private static final double[] NORMAL2_A = new double[]{0.6101430819232004, -0.4348412727125775, 0.1763511936436055, -0.06071079560924941, 0.017712068995694115, -0.004321119385567294, 8.542166768870987E-4, -1.2715509060916275E-4, 1.1248167243671189E-5, 3.1306388542182096E-7, -2.70988068537762E-7, 3.073762270140769E-8, 2.515620384817623E-9, -1.0289299213203192E-9, 2.994405211994994E-11, 2.6051789687266936E-11, -2.6348399241719693E-12, -6.434045098906365E-13, 1.1245740180166345E-13, 1.7281533389986097E-14, -4.264101694942375E-15, -5.45371977880191E-16, 1.58697607761671E-16, 2.0899837844334E-17, -5.900526869409E-18, -9.41893387554E-19};
    private static final double[] InvP1 = new double[]{16.030495584406623, -90.78495926296033, 186.44914861620987, -169.0014273464238, 65.45466284794487, -8.642130115872478, 0.176058782139059};
    private static final double[] InvQ1 = new double[]{14.780647071513831, -91.37416702426032, 210.1579048620532, -222.10254121855132, 107.60453916055124, -20.601073032826545, 1.0};
    private static final double[] InvP2 = new double[]{-0.015238926344072612, 0.3444556924136125, -2.9344398672542478, 11.763505705217828, -22.655292823101103, 19.12133439658033, -5.478927619598319, 0.237516689024448};
    private static final double[] InvQ2 = new double[]{-0.010846516960205995, 0.2610628885843079, -2.406831810439376, 10.695129973387015, -23.71671552159658, 24.640158943917285, -10.01437634978307, 1.0};
    private static final double[] InvP3 = new double[]{5.6451977709864484E-5, 0.005350414748789302, 0.12969550099727353, 1.0426158549298266, 2.830267790175449, 2.6255672879448073, 2.078974263017492, 0.7271880623155681, 0.066816807711805, -0.01779100457511176, 0.0022419563223346345};
    private static final double[] InvQ3 = new double[]{5.645169986276065E-5, 0.005350558706793065, 0.12986615416911648, 1.0542932232626492, 3.0379331173522206, 3.763116853640503, 3.878285827704201, 2.0372431817412178, 1.0};

    public NormalDist() {
        this.setParams(0.0, 1.0);
    }

    public NormalDist(double mu, double sigma) {
        this.setParams(mu, sigma);
    }

    @Override
    public double density(double x) {
        double z = (x - this.mu) / this.sigma;
        return Math.exp(-0.5 * z * z) / (2.5066282746310007 * this.sigma);
    }

    @Override
    public double cdf(double x) {
        return NormalDist.cdf01((x - this.mu) / this.sigma);
    }

    @Override
    public double barF(double x) {
        return NormalDist.barF01((x - this.mu) / this.sigma);
    }

    @Override
    public double inverseF(double u) {
        return this.mu + this.sigma * NormalDist.inverseF01(u);
    }

    @Override
    public double getMean() {
        return NormalDist.getMean(this.mu, this.sigma);
    }

    @Override
    public double getVariance() {
        return NormalDist.getVariance(this.mu, this.sigma);
    }

    @Override
    public double getStandardDeviation() {
        return NormalDist.getStandardDeviation(this.mu, this.sigma);
    }

    public static double density01(double x) {
        return Math.exp(-0.5 * x * x) / 2.5066282746310007;
    }

    public static double density(double mu, double sigma, double x) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        double z = (x - mu) / sigma;
        return Math.exp(-0.5 * z * z) / (2.5066282746310007 * sigma);
    }

    public static double cdf01(double x) {
        double r;
        if (x <= -100.0) {
            return 0.0;
        }
        if (x >= 100.0) {
            return 1.0;
        }
        if ((x = -x / 1.4142135623730951) < 0.0) {
            x = -x;
            double t = (x - 3.75) / (x + 3.75);
            r = 1.0 - 0.5 * Math.exp(-x * x) * Num.evalCheby(NORMAL2_A, 24, t);
        } else {
            double t = (x - 3.75) / (x + 3.75);
            r = 0.5 * Math.exp(-x * x) * Num.evalCheby(NORMAL2_A, 24, t);
        }
        return r;
    }

    public static double cdf(double mu, double sigma, double x) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        return NormalDist.cdf01((x - mu) / sigma);
    }

    public static double barF01(double x) {
        boolean neg;
        double KK = 5.303300858899107;
        if (x >= 100.0) {
            return 0.0;
        }
        if (x <= -100.0) {
            return 1.0;
        }
        if (x >= 0.0) {
            neg = false;
        } else {
            neg = true;
            x = -x;
        }
        double t = (x - 5.303300858899107) / (x + 5.303300858899107);
        double y = Num.evalCheby(AbarF, 24, t);
        y = y * Math.exp(-x * x / 2.0) / 2.0;
        if (neg) {
            return 1.0 - y;
        }
        return y;
    }

    public static double barF(double mu, double sigma, double x) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        return NormalDist.barF01((x - mu) / sigma);
    }

    public static double inverseF01(double u) {
        double z;
        int i;
        double v;
        double w;
        double y;
        boolean negatif;
        double x = u;
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u is not in [0, 1]");
        }
        if (u <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (u >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if ((x = 2.0 * x - 1.0) < 0.0) {
            x = -x;
            negatif = true;
        } else {
            negatif = false;
        }
        if (x <= 0.75) {
            y = x * x - 0.5625;
            w = 0.0;
            v = 0.0;
            for (i = 6; i >= 0; --i) {
                v = v * y + InvP1[i];
                w = w * y + InvQ1[i];
            }
            z = v / w * x;
        } else if (x <= 0.9375) {
            y = x * x - 0.87890625;
            w = 0.0;
            v = 0.0;
            for (i = 7; i >= 0; --i) {
                v = v * y + InvP2[i];
                w = w * y + InvQ2[i];
            }
            z = v / w * x;
        } else {
            y = u > 0.5 ? 1.0 / Math.sqrt(-Math.log(1.0 - x)) : 1.0 / Math.sqrt(-Math.log(2.0 * u));
            v = 0.0;
            for (i = 10; i >= 0; --i) {
                v = v * y + InvP3[i];
            }
            w = 0.0;
            for (i = 8; i >= 0; --i) {
                w = w * y + InvQ3[i];
            }
            z = v / w / y;
        }
        if (negatif) {
            if (u < 1.0E-105) {
                double RACPI = 1.772453850905516;
                w = Math.exp(-z * z) / 1.772453850905516;
                y = 2.0 * z * z;
                v = 1.0;
                double term = 1.0;
                for (i = 0; i < 6; ++i) {
                    v += (term *= (double)(-(2 * i + 1)) / y);
                }
                z -= u / w - 0.5 * v / z;
            }
            return -(z * 1.4142135623730951);
        }
        return z * 1.4142135623730951;
    }

    public static double inverseF(double mu, double sigma, double u) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        return mu + sigma * NormalDist.inverseF01(u);
    }

    public static double[] getMLE(double[] x, int n) {
        int i;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double[] parameters = new double[2];
        double sum = 0.0;
        for (i = 0; i < n; ++i) {
            sum += x[i];
        }
        parameters[0] = sum / (double)n;
        sum = 0.0;
        for (i = 0; i < n; ++i) {
            sum += (x[i] - parameters[0]) * (x[i] - parameters[0]);
        }
        parameters[1] = Math.sqrt(sum / (double)n);
        return parameters;
    }

    public static NormalDist getInstanceFromMLE(double[] x, int n) {
        double[] parameters = NormalDist.getMLE(x, n);
        return new NormalDist(parameters[0], parameters[1]);
    }

    public static double getMean(double mu, double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        return mu;
    }

    public static double getVariance(double mu, double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        return sigma * sigma;
    }

    public static double getStandardDeviation(double mu, double sigma) {
        return sigma;
    }

    public double getMu() {
        return this.mu;
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setParams(double mu, double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        this.mu = mu;
        this.sigma = sigma;
    }

    @Override
    public double[] getParams() {
        double[] retour = new double[]{this.mu, this.sigma};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : mu = " + this.mu + ", sigma = " + this.sigma;
    }
}

