/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.probdistmulti;

import umontreal.ssj.probdist.NormalDist;
import umontreal.ssj.probdistmulti.BiNormalDist;
import umontreal.ssj.util.Num;

public class BiNormalDonnellyDist
extends BiNormalDist {
    private static final double TWOPI = Math.PI * 2;
    private static final double SQRTPI = Math.sqrt(Math.PI);
    private static final int KMAX = 6;
    private static double[] BB = new double[7];
    private static final double[] CB = new double[]{0.9999936, -0.9992989, 0.9872976, -0.9109973, 0.6829098, -0.336021, 0.07612251};

    private static double BorthT(double h, double a) {
        int k;
        double w = a * h / 1.4142135623730951;
        double w2 = w * w;
        double z = w * Math.exp(-w2);
        BiNormalDonnellyDist.BB[0] = SQRTPI * (BiNormalDonnellyDist.Gauss(1.4142135623730951 * w) - 0.5);
        for (k = 1; k <= 6; ++k) {
            BiNormalDonnellyDist.BB[k] = ((double)(2 * k - 1) * BB[k - 1] - z) / 2.0;
            z *= w2;
        }
        double h2 = h * h / 2.0;
        z = h / 1.4142135623730951;
        double sum = 0.0;
        for (k = 0; k <= 6; ++k) {
            sum += CB[k] * BB[k] / z;
            z *= h2;
        }
        return sum * Math.exp(-h2) / (Math.PI * 2);
    }

    public BiNormalDonnellyDist(double rho, int ndig) {
        super(rho);
        if (ndig > 15) {
            throw new IllegalArgumentException("ndig > 15");
        }
        this.decPrec = this.ndigit = ndig;
    }

    public BiNormalDonnellyDist(double rho) {
        this(rho, 15);
    }

    public BiNormalDonnellyDist(double mu1, double sigma1, double mu2, double sigma2, double rho, int ndig) {
        super(mu1, sigma1, mu2, sigma2, rho);
        if (ndig > 15) {
            throw new IllegalArgumentException("ndig > 15");
        }
        this.decPrec = this.ndigit = ndig;
    }

    public BiNormalDonnellyDist(double mu1, double sigma1, double mu2, double sigma2, double rho) {
        this(mu1, sigma1, mu2, sigma2, rho, 15);
    }

    public static double cdf(double x, double y, double rho, int ndig) {
        double gk;
        double gh;
        if (ndig > 15) {
            throw new IllegalArgumentException("ndig > 15");
        }
        double b = BiNormalDonnellyDist.specialCDF(x, y, rho, 13.0);
        if (b >= 0.0) {
            return b;
        }
        b = 0.0;
        boolean SINGLE_FLAG = ndig <= 7;
        double TWO_PI = Math.PI * 2;
        double r = rho;
        double ah = -x;
        double ak = -y;
        double gw = 0.0;
        double wh = 0.0;
        double wk = 0.0;
        int is = -1;
        if (SINGLE_FLAG) {
            gh = BiNormalDonnellyDist.Gauss(x) / 2.0;
            gk = BiNormalDonnellyDist.Gauss(y) / 2.0;
        } else {
            gh = NormalDist.cdf01(x) / 2.0;
            gk = NormalDist.cdf01(y) / 2.0;
        }
        boolean flag = true;
        double rr = (1.0 - r) * (1.0 + r);
        if (rr < 0.0) {
            throw new IllegalArgumentException("|rho| > 1");
        }
        double sqr = Math.sqrt(rr);
        double con = Math.PI * Num.TEN_NEG_POW[ndig];
        double EPSILON = 0.5 * Num.TEN_NEG_POW[ndig];
        if (ah != 0.0) {
            b = gh;
            if (ah * ak < 0.0) {
                b -= 0.5;
            } else if (ah * ak == 0.0) {
                flag = false;
            }
        } else if (ak == 0.0) {
            return Math.asin(r) / (Math.PI * 2) + 0.25;
        }
        if (flag) {
            b += gk;
        }
        if (ah != 0.0) {
            flag = false;
            wh = -ah;
            wk = (ak / ah - r) / sqr;
            gw = 2.0 * gh;
            is = -1;
        }
        do {
            if (flag) {
                wh = -ak;
                wk = (ah / ak - r) / sqr;
                gw = 2.0 * gk;
                is = 1;
            }
            flag = true;
            double sgn = -1.0;
            double t = 0.0;
            if (wk != 0.0) {
                double s1;
                if (Math.abs(wk) >= 1.0) {
                    if (Math.abs(wk) == 1.0) {
                        t = wk * gw * (1.0 - gw) / 2.0;
                        b += sgn * t;
                        if (is < 0) continue;
                        break;
                    }
                    sgn = -sgn;
                    double g2 = SINGLE_FLAG ? BiNormalDonnellyDist.Gauss(wh) : NormalDist.cdf01(wh *= wk);
                    if ((wk = 1.0 / wk) < 0.0) {
                        b += 0.5;
                    }
                    b = b - (gw + g2) / 2.0 + gw * g2;
                }
                double h2 = wh * wh;
                double a2 = wk * wk;
                double h4 = h2 * 0.5;
                double ex = 0.0;
                if (h4 < 300.0) {
                    ex = Math.exp(-h4);
                }
                double w2 = h4 * ex;
                double ap = 1.0;
                double s2 = ap - ex;
                double sp = ap;
                double sn = s1 = 0.0;
                double conex = Math.abs(con / wk);
                while (true) {
                    double cn = ap * s2 / (sn + sp);
                    s1 += cn;
                    if (Math.abs(cn) <= conex) break;
                    sn = sp;
                    s2 -= w2;
                    w2 *= h4 / (sp += 1.0);
                    ap = -ap * a2;
                }
                t = (Math.atan(wk) - wk * s1) / (Math.PI * 2);
                b += sgn * t;
            }
            if (is >= 0) break;
        } while (ak != 0.0);
        if (b < EPSILON) {
            b = 0.0;
        }
        if (b > 1.0) {
            b = 1.0;
        }
        return b;
    }

    public static double cdf(double mu1, double sigma1, double x, double mu2, double sigma2, double y, double rho, int ndig) {
        if (sigma1 <= 0.0) {
            throw new IllegalArgumentException("sigma1 <= 0");
        }
        if (sigma2 <= 0.0) {
            throw new IllegalArgumentException("sigma2 <= 0");
        }
        double X = (x - mu1) / sigma1;
        double Y = (y - mu2) / sigma2;
        return BiNormalDonnellyDist.cdf(X, Y, rho, ndig);
    }

    public static double barF(double mu1, double sigma1, double x, double mu2, double sigma2, double y, double rho, int ndig) {
        if (sigma1 <= 0.0) {
            throw new IllegalArgumentException("sigma1 <= 0");
        }
        if (sigma2 <= 0.0) {
            throw new IllegalArgumentException("sigma2 <= 0");
        }
        double X = (x - mu1) / sigma1;
        double Y = (y - mu2) / sigma2;
        return BiNormalDonnellyDist.barF(X, Y, rho, ndig);
    }

    public static double barF(double x, double y, double rho, int ndig) {
        return BiNormalDonnellyDist.cdf(-x, -y, rho, ndig);
    }

    @Override
    public double cdf(double x, double y) {
        return BiNormalDonnellyDist.cdf((x - this.mu1) / this.sigma1, (y - this.mu2) / this.sigma2, this.rho, this.ndigit);
    }

    public static double cdf(double x, double y, double rho) {
        return BiNormalDonnellyDist.cdf(x, y, rho, 15);
    }

    public static double cdf(double mu1, double sigma1, double x, double mu2, double sigma2, double y, double rho) {
        return BiNormalDonnellyDist.cdf(mu1, sigma1, x, mu2, sigma2, y, rho, 15);
    }

    @Override
    public double barF(double x, double y) {
        return BiNormalDonnellyDist.barF((x - this.mu1) / this.sigma1, (y - this.mu2) / this.sigma2, this.rho, this.ndigit);
    }

    public static double barF(double mu1, double sigma1, double x, double mu2, double sigma2, double y, double rho) {
        return BiNormalDonnellyDist.barF(mu1, sigma1, x, mu2, sigma2, y, rho, 15);
    }

    public static double barF(double x, double y, double rho) {
        return BiNormalDonnellyDist.barF(x, y, rho, 15);
    }
}

