/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvar;

import umontreal.ssj.probdist.ExponentialDist;
import umontreal.ssj.randvar.RandomVariateGen;
import umontreal.ssj.rng.RandomStream;

public class ExponentialGen
extends RandomVariateGen {
    protected double lambda;

    public ExponentialGen(RandomStream s, double lambda) {
        super(s, new ExponentialDist(lambda));
        this.setParams(lambda);
    }

    public ExponentialGen(RandomStream s, ExponentialDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getLambda());
        }
    }

    public static double nextDouble(RandomStream s, double lambda) {
        return ExponentialDist.inverseF(lambda, s.nextDouble());
    }

    public double getLambda() {
        return this.lambda;
    }

    protected void setParams(double lam) {
        if (lam <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        this.lambda = lam;
    }
}

