/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvar;

import umontreal.ssj.probdist.DiscreteDistributionInt;
import umontreal.ssj.randvar.RandomVariateGen;
import umontreal.ssj.rng.RandomStream;

public class RandomVariateGenInt
extends RandomVariateGen {
    protected RandomVariateGenInt() {
    }

    public RandomVariateGenInt(RandomStream s, DiscreteDistributionInt dist) {
        this.stream = s;
        this.dist = dist;
    }

    public int nextInt() {
        return ((DiscreteDistributionInt)this.dist).inverseFInt(this.stream.nextDouble());
    }

    public void nextArrayOfInt(int[] v, int start, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n must be positive.");
        }
        for (int i = 0; i < n; ++i) {
            v[start + i] = this.nextInt();
        }
    }

    public int[] nextArrayOfInt(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive.");
        }
        int[] v = new int[n];
        for (int i = 0; i < n; ++i) {
            v[i] = this.nextInt();
        }
        return v;
    }

    @Override
    public DiscreteDistributionInt getDistribution() {
        return (DiscreteDistributionInt)this.dist;
    }
}

