/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stat;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Formatter;
import java.util.Locale;
import umontreal.ssj.stat.ScaledHistogram;

public class HistogramChartToLatex {
    public double getMinY(double[] height) {
        double min = height[0];
        for (int i = 1; i < height.length; ++i) {
            if (!(height[i] < min)) continue;
            min = height[i];
        }
        return min;
    }

    public double getMaxY(double[] height) {
        double max = height[0];
        for (int i = 1; i < height.length; ++i) {
            if (!(height[i] > max)) continue;
            max = height[i];
        }
        return max;
    }

    public double[] getHistogramBound(ScaledHistogram scaledH) {
        double a = scaledH.getA();
        double b = scaledH.getB();
        int nBin = scaledH.getNumBins();
        double h = (b - a) / (double)nBin;
        double[] bound = new double[nBin + 1];
        bound[0] = a;
        for (int i = 1; i <= nBin; ++i) {
            bound[i] = bound[i - 1] + h;
        }
        return bound;
    }

    public String toLatex(ScaledHistogram scaledH, boolean poly, boolean hist) {
        double[] height = scaledH.getHeights();
        double[] bound = this.getHistogramBound(scaledH);
        return this.toLatex(bound, height, poly, hist);
    }

    public String toLatex(double[] bound, double[] height, boolean poly, boolean hist) {
        int i;
        if (!poly && !hist) {
            hist = true;
        }
        double h = (bound[1] - bound[0]) / 2.0;
        double yMin = this.getMinY(height);
        double yMax = this.getMaxY(height) + 0.2 * this.getMaxY(height);
        Formatter formatter = new Formatter(Locale.US);
        formatter.format("\\documentclass[border=3mm, %n", new Object[0]);
        formatter.format("           tikz, %n", new Object[0]);
        formatter.format("           preview %n", new Object[0]);
        formatter.format("           ]{standalone} %n%n", new Object[0]);
        formatter.format("\\usepackage{pgfplots}", new Object[0]);
        formatter.format("%n%n", new Object[0]);
        formatter.format("\\begin{document}%n%n", new Object[0]);
        formatter.format("%%---------------------------------------------------------------%%%n", new Object[0]);
        formatter.format("\\begin{tikzpicture} %n%n", new Object[0]);
        formatter.format("\\begin{axis}[ %n", new Object[0]);
        formatter.format("        ymin=%s, ymax=%s,%n", yMin, yMax);
        formatter.format("        minor y tick num = 3, %n", new Object[0]);
        formatter.format("        %%area style, %n", new Object[0]);
        formatter.format("        ] %n", new Object[0]);
        if (hist) {
            formatter.format("\\addplot+[ybar interval,mark=no] plot coordinates { ", new Object[0]);
            for (i = 0; i < height.length; ++i) {
                formatter.format("\n (%s,%s) ", bound[i], height[i]);
            }
            formatter.format("};%n%n", new Object[0]);
        }
        if (poly) {
            formatter.format("\\addplot+[sharp plot] plot coordinates { ", new Object[0]);
            formatter.format("(%s,%s) ", bound[0], height[0]);
            for (i = 0; i < height.length; ++i) {
                formatter.format("\n (%s,%s) ", bound[i] + h, height[i]);
            }
            formatter.format("(%s,%s) ", bound[bound.length - 1], height[height.length - 1]);
            formatter.format("};%n%n", new Object[0]);
        }
        formatter.format("\\end{axis} %n%n", new Object[0]);
        formatter.format("\\end{tikzpicture} %n%n", new Object[0]);
        formatter.format("\\end{document}%n", new Object[0]);
        String ch = formatter.toString();
        formatter.close();
        return ch;
    }

    public void writeStringTofile(String name, String chaine) throws IOException {
        String currentDir = System.getProperty("user.dir");
        File file = new File(currentDir + "/" + name + ".tex");
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        FileOutputStream stream = new FileOutputStream(file, true);
        PrintWriter out = new PrintWriter(new OutputStreamWriter(stream));
        out.println(chaine);
        out.close();
    }
}

