/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.util;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.CholeskyDecomposition;
import cern.colt.matrix.linalg.LUDecomposition;
import cern.colt.matrix.linalg.LUDecompositionQuick;
import cern.colt.matrix.linalg.SingularValueDecomposition;
import cern.jet.math.Functions;
import umontreal.ssj.util.Num;
import umontreal.ssj.util.PrintfFormat;

public class DMatrix {
    private double[][] mat;
    private int r;
    private int c;
    private static double[] cPade = new double[]{1.76432256E10, 8.8216128E9, 2.0756736E9, 3.027024E8, 3.027024E7, 2162160.0, 110880.0, 3960.0, 90.0, 1.0};
    private static double[] p_em1 = new double[]{1.0, 0.03333333333333333, 0.03333333333333333, 0.0010683760683760685, 2.1367521367521368E-4, 5.8275058275058275E-6, 2.775002775002775E-7, 3.854170520837187E-9};
    private static double[] q_em1 = new double[]{1.0, -0.4666666666666667, 0.1, -0.01282051282051282, 0.0010683760683760685, -5.8275058275058275E-5, 1.9425019425019425E-6, -3.08333641666975E-8};

    private static void innerMultBand(DoubleMatrix2D A0, int sa, DoubleMatrix2D B0, int sb, DoubleMatrix2D C) {
        DoubleMatrix2D A = A0 == C ? A0.copy() : A0;
        DoubleMatrix2D B = B0 == C ? B0.copy() : B0;
        C.assign(0.0);
        int n = A.rows();
        for (int i = 0; i < n; ++i) {
            int jmax = Math.min(i + sa + sb, n - 1);
            for (int j = i; j <= jmax; ++j) {
                int kmin = Math.max(i, j - sb);
                int kmax = Math.min(i + sa, j);
                double z = 0.0;
                for (int k = kmin; k <= kmax; ++k) {
                    double x = A.getQuick(i, k);
                    double y = B.getQuick(k, j);
                    z += x * y;
                }
                C.setQuick(i, j, z);
            }
        }
    }

    private static int getScale(DoubleMatrix2D A, double theta) {
        double norm = DMatrix.norm1bidiag(A) / theta;
        int s = norm > 1.0 ? (int)Math.ceil(Num.log2(norm)) : 0;
        return s;
    }

    private static DoubleMatrix2D m_taylor(DoubleMatrix2D A) {
        double EPS = 1.0E-12;
        int k = A.rows();
        int JMAX = 2 * k + 100;
        DoubleMatrix2D Sum = A.copy();
        DoubleMatrix2D Term = A.copy();
        Functions F = Functions.functions;
        Algebra alge = new Algebra();
        for (int j = 2; j <= JMAX; ++j) {
            Term = alge.mult(A, Term);
            Term.assign(Functions.mult((double)(1.0 / (double)j)));
            Sum.assign(Term, Functions.plus);
            if (j <= k + 5) continue;
            double normS = alge.normInfinity(Sum);
            double normT = alge.normInfinity(Term);
            if (normT <= normS * 1.0E-12) break;
        }
        return Sum;
    }

    private static DoubleMatrix1D m_taylor(DoubleMatrix2D A, DoubleMatrix1D b) {
        double EPS = 1.0E-12;
        int k = A.rows();
        int JMAX = 2 * k + 100;
        DoubleFactory1D factory = DoubleFactory1D.dense;
        DoubleMatrix1D Term = b.copy();
        DoubleMatrix1D Sum = factory.make(k);
        Functions F = Functions.functions;
        Algebra alge = new Algebra();
        for (int j = 1; j <= JMAX; ++j) {
            double Snorm;
            double Tnorm;
            Term = alge.mult(A, Term);
            Term.assign(Functions.mult((double)(1.0 / (double)j)));
            Sum.assign(Term, Functions.plus);
            if (j > k + 5 && (Tnorm = alge.norm1(Term)) <= (Snorm = alge.norm1(Sum)) * 1.0E-12) break;
        }
        return Sum;
    }

    private static DoubleMatrix2D m_expmiBidiag(DoubleMatrix2D A) {
        int n = A.rows();
        DoubleMatrix2D B = A.copy();
        DoubleFactory2D fac = DoubleFactory2D.dense;
        DoubleMatrix2D I = fac.identity(n);
        DoubleMatrix2D B2 = fac.make(n, n);
        DoubleMatrix2D B4 = fac.make(n, n);
        DoubleMatrix2D B6 = fac.make(n, n);
        DMatrix.multBand(B, 1, B, 1, B2);
        DMatrix.multBand(B2, 2, B2, 2, B4);
        DMatrix.multBand(B4, 4, B2, 2, B6);
        DoubleMatrix2D V = B6.copy();
        DoubleMatrix2D U = B4.copy();
        DMatrix.addMultBand(p_em1[4], U, 4, p_em1[2], B2, 2);
        DMatrix.addMultBand(p_em1[6], V, 6, p_em1[0], I, 0);
        DMatrix.addMultBand(1.0, V, 6, 1.0, U, 6);
        DoubleMatrix2D W = B6.copy();
        U = B4.copy();
        DMatrix.addMultBand(p_em1[5], U, 4, p_em1[3], B2, 2);
        DMatrix.addMultBand(p_em1[7], W, 6, p_em1[1], I, 0);
        DMatrix.addMultBand(1.0, W, 6, 1.0, U, 6);
        DMatrix.multBand(W, 6, B, 1, U);
        DMatrix.addMultBand(1.0, V, 6, 1.0, U, 7);
        DoubleMatrix2D N = V.copy();
        V = B6.copy();
        U = B4.copy();
        DMatrix.addMultBand(q_em1[4], U, 4, q_em1[2], B2, 2);
        DMatrix.addMultBand(q_em1[6], V, 6, q_em1[0], I, 0);
        DMatrix.addMultBand(1.0, V, 6, 1.0, U, 6);
        W = B6.copy();
        U = B4.copy();
        DMatrix.addMultBand(q_em1[5], U, 4, q_em1[3], B2, 2);
        DMatrix.addMultBand(q_em1[7], W, 6, q_em1[1], I, 0);
        DMatrix.addMultBand(1.0, W, 6, 1.0, U, 6);
        DMatrix.multBand(W, 6, B, 1, U);
        DMatrix.addMultBand(1.0, V, 6, 1.0, U, 7);
        DMatrix.solveTriangular(V, N, W);
        DMatrix.multBand(B, 1, W, n - 1, U);
        return U;
    }

    static void addMultTriang(DoubleMatrix2D A, DoubleMatrix1D b, double h) {
        int n = A.rows();
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                double z = A.getQuick(i, j) * b.getQuick(j);
                b.setQuick(i, h * z);
            }
        }
    }

    private static double norm1bidiag(DoubleMatrix2D B) {
        int n = B.rows();
        double norm = Math.abs(B.getQuick(0, 0));
        for (int i = 1; i < n; ++i) {
            double x = Math.abs(B.getQuick(i - 1, i)) + Math.abs(B.getQuick(i, i));
            if (!(x > norm)) continue;
            norm = x;
        }
        return norm;
    }

    public DMatrix(int r, int c) {
        this.mat = new double[r][c];
        this.r = r;
        this.c = c;
    }

    public DMatrix(double[][] data, int r, int c) {
        this(r, c);
        for (int i = 0; i < r; ++i) {
            for (int j = 0; j < c; ++j) {
                this.mat[i][j] = data[i][j];
            }
        }
    }

    public DMatrix(DMatrix that) {
        this(that.mat, that.r, that.c);
    }

    public static void CholeskyDecompose(double[][] M, double[][] L) {
        int j;
        int i;
        int d = M.length;
        DenseDoubleMatrix2D MM = new DenseDoubleMatrix2D(M);
        DenseDoubleMatrix2D LL = new DenseDoubleMatrix2D(d, d);
        CholeskyDecomposition decomp = new CholeskyDecomposition((DoubleMatrix2D)MM);
        LL = decomp.getL();
        for (i = 0; i < L.length; ++i) {
            for (j = 0; j <= i; ++j) {
                L[i][j] = LL.get(i, j);
            }
        }
        for (i = 0; i < L.length; ++i) {
            for (j = i + 1; j < L.length; ++j) {
                L[i][j] = 0.0;
            }
        }
    }

    public static DoubleMatrix2D CholeskyDecompose(DoubleMatrix2D M) {
        CholeskyDecomposition decomp = new CholeskyDecomposition(M);
        return decomp.getL();
    }

    public static void PCADecompose(double[][] M, double[][] A, double[] lambda) {
        int d = M.length;
        DenseDoubleMatrix2D MM = new DenseDoubleMatrix2D(M);
        DenseDoubleMatrix2D AA = new DenseDoubleMatrix2D(d, d);
        AA = DMatrix.PCADecompose((DoubleMatrix2D)MM, lambda);
        for (int i = 0; i < d; ++i) {
            for (int j = 0; j < d; ++j) {
                A[i][j] = AA.get(i, j);
            }
        }
    }

    public static DoubleMatrix2D PCADecompose(DoubleMatrix2D M, double[] lambda) {
        int i;
        SingularValueDecomposition sv = new SingularValueDecomposition(M);
        DoubleMatrix2D D = sv.getS();
        for (i = 0; i < D.rows(); ++i) {
            lambda[i] = D.getQuick(i, i);
        }
        for (i = 0; i < D.rows(); ++i) {
            D.setQuick(i, i, Math.sqrt(lambda[i]));
        }
        DoubleMatrix2D P = sv.getV();
        return P.zMult(D, null);
    }

    public static double[] solveLU(double[][] A, double[] b) {
        DenseDoubleMatrix2D M = new DenseDoubleMatrix2D(A);
        DenseDoubleMatrix1D c = new DenseDoubleMatrix1D(b);
        LUDecompositionQuick lu = new LUDecompositionQuick();
        lu.decompose((DoubleMatrix2D)M);
        lu.solve((DoubleMatrix1D)c);
        return c.toArray();
    }

    public static void solveTriangular(DoubleMatrix2D U, DoubleMatrix2D B, DoubleMatrix2D X) {
        int n = U.rows();
        int m = B.columns();
        X.assign(0.0);
        for (int j = 0; j < m; ++j) {
            for (int i = n - 1; i >= 0; --i) {
                double z = B.getQuick(i, j);
                for (int k = i + 1; k < n; ++k) {
                    z -= U.getQuick(i, k) * X.getQuick(k, j);
                }
                X.setQuick(i, j, z /= U.getQuick(i, i));
            }
        }
    }

    public static double[][] exp(double[][] A) {
        DenseDoubleMatrix2D V = new DenseDoubleMatrix2D(A);
        DoubleMatrix2D R = DMatrix.exp((DoubleMatrix2D)V);
        return R.toArray();
    }

    public static DoubleMatrix2D exp(DoubleMatrix2D A) {
        DoubleMatrix2D B = A.copy();
        int n = B.rows();
        Algebra alge = new Algebra();
        double mu = alge.trace(B) / (double)n;
        for (int i = 0; i < n; ++i) {
            double x = B.getQuick(i, i);
            B.setQuick(i, i, x - mu);
        }
        double THETA9 = 2.097847961257068;
        int s = DMatrix.getScale(B, 2.097847961257068);
        Functions F = Functions.functions;
        double v = 1.0 / Math.pow(2.0, s);
        if (v <= 0.0) {
            throw new IllegalArgumentException("   v <= 0");
        }
        B.assign(Functions.mult((double)v));
        DoubleFactory2D fac = DoubleFactory2D.dense;
        DoubleMatrix2D B0 = fac.identity(n);
        DoubleMatrix2D B2 = alge.mult(B, B);
        DoubleMatrix2D B4 = alge.mult(B2, B2);
        DoubleMatrix2D T = B2.copy();
        DoubleMatrix2D W = B4.copy();
        W.assign(Functions.mult((double)cPade[9]));
        W.assign(T, Functions.plusMult((double)cPade[7]));
        DoubleMatrix2D U = alge.mult(B4, W);
        W = B4.copy();
        W.assign(Functions.mult((double)cPade[5]));
        W.assign(T, Functions.plusMult((double)cPade[3]));
        W.assign(B0, Functions.plusMult((double)cPade[1]));
        U.assign(W, Functions.plus);
        U = alge.mult(B, U);
        W = B4.copy();
        W.assign(Functions.mult((double)cPade[8]));
        W.assign(T, Functions.plusMult((double)cPade[6]));
        DoubleMatrix2D V = alge.mult(B4, W);
        W = B4.copy();
        W.assign(Functions.mult((double)cPade[4]));
        W.assign(T, Functions.plusMult((double)cPade[2]));
        W.assign(B0, Functions.plusMult((double)cPade[0]));
        V.assign(W, Functions.plus);
        W = V.copy();
        W.assign(U, Functions.plus);
        T = V.copy();
        T.assign(U, Functions.minus);
        LUDecomposition lu = new LUDecomposition(T);
        B = lu.solve(W);
        double r = mu * v;
        r = Math.exp(r);
        B.assign(Functions.mult((double)r));
        for (int i = 0; i < s; ++i) {
            B = alge.mult(B, B);
        }
        return B;
    }

    public static DoubleMatrix2D expBidiagonal(DoubleMatrix2D A) {
        double x;
        DoubleMatrix2D B = A.copy();
        int n = B.rows();
        Algebra alge = new Algebra();
        double mu = alge.trace(B) / (double)n;
        for (int i = 0; i < n; ++i) {
            x = B.getQuick(i, i);
            B.setQuick(i, i, x - mu);
        }
        double THETA9 = 2.097847961257068;
        int s = DMatrix.getScale(B, 2.097847961257068);
        double v = 1.0 / Math.pow(2.0, s);
        if (v <= 0.0) {
            throw new IllegalArgumentException("   v <= 0");
        }
        DMatrix.multBand(B, 1, v);
        DoubleFactory2D fac = DoubleFactory2D.dense;
        DoubleMatrix2D T = fac.make(n, n);
        DoubleMatrix2D B4 = fac.make(n, n);
        DMatrix.multBand(B, 1, B, 1, T);
        DMatrix.multBand(T, 2, T, 2, B4);
        DoubleMatrix2D W = B4.copy();
        DMatrix.addMultBand(cPade[9], W, 4, cPade[7], T, 2);
        DoubleMatrix2D U = fac.make(n, n);
        DMatrix.multBand(W, 4, B4, 4, U);
        W = B4.copy();
        DMatrix.addMultBand(cPade[5], W, 4, cPade[3], T, 2);
        for (int i = 0; i < n; ++i) {
            x = W.getQuick(i, i);
            W.setQuick(i, i, x + cPade[1]);
        }
        DMatrix.addMultBand(1.0, U, 8, 1.0, W, 4);
        DMatrix.multBand(B, 1, U, 8, U);
        W = B4.copy();
        DMatrix.addMultBand(cPade[8], W, 4, cPade[6], T, 2);
        DoubleMatrix2D V = B;
        DMatrix.multBand(W, 4, B4, 4, V);
        W = B4.copy();
        DMatrix.addMultBand(cPade[4], W, 4, cPade[2], T, 2);
        for (int i = 0; i < n; ++i) {
            x = W.getQuick(i, i);
            W.setQuick(i, i, x + cPade[0]);
        }
        DMatrix.addMultBand(1.0, V, 8, 1.0, W, 4);
        W = V.copy();
        DMatrix.addMultBand(1.0, W, 9, 1.0, U, 9);
        T = V.copy();
        DMatrix.addMultBand(1.0, T, 9, -1.0, U, 9);
        DMatrix.solveTriangular(T, W, B);
        double r = mu * v;
        r = Math.exp(r);
        DMatrix.multBand(B, n - 1, r);
        T.assign(0.0);
        for (int i = 0; i < s; ++i) {
            DMatrix.multBand(B, n - 1, B, n - 1, T);
            B = T.copy();
        }
        return B;
    }

    public static DoubleMatrix1D expBidiagonal(DoubleMatrix2D A, DoubleMatrix1D b) {
        DoubleMatrix2D U = DMatrix.expBidiagonal(A);
        Algebra alge = new Algebra();
        return alge.mult(U, b);
    }

    public static DoubleMatrix2D expmiBidiagonal(DoubleMatrix2D A) {
        DoubleMatrix2D B = A.copy();
        double THETA = 1.13;
        int s = DMatrix.getScale(B, 1.13);
        double v = 1.0 / Math.pow(2.0, s);
        if (v <= 0.0) {
            throw new IllegalArgumentException("   v <= 0");
        }
        DMatrix.multBand(B, 1, v);
        DoubleMatrix2D U = DMatrix.m_expmiBidiag(B);
        DoubleMatrix2D N = U.copy();
        DMatrix.addIdentity(N);
        DoubleMatrix2D V = N.copy();
        Algebra alge = new Algebra();
        for (int i = 1; i <= s; ++i) {
            DMatrix.addIdentity(N);
            U = alge.mult(N, U);
            if (i >= s) continue;
            V = alge.mult(V, V);
            N = V.copy();
        }
        return U;
    }

    public static DoubleMatrix1D expmiBidiagonal(DoubleMatrix2D A, DoubleMatrix1D b) {
        DoubleMatrix2D F = A.copy();
        int s = DMatrix.getScale(F, 0.0625);
        double v = 1.0 / Math.pow(2.0, s);
        if (v <= 0.0) {
            throw new IllegalArgumentException("   v <= 0");
        }
        DMatrix.multBand(F, 1, v);
        DoubleMatrix2D U = DMatrix.expBidiagonal(F);
        DoubleMatrix2D N = U.copy();
        DoubleMatrix1D C = DMatrix.m_taylor(F, b);
        DoubleMatrix1D D = C.copy();
        Algebra alge = new Algebra();
        for (int i = 1; i <= s; ++i) {
            DMatrix.addIdentity(N);
            C = alge.mult(N, C);
            if (i >= s) continue;
            U = alge.mult(U, U);
            N = U.copy();
        }
        return C;
    }

    private static void addIdentity(DoubleMatrix2D A) {
        int n = A.rows();
        for (int i = 0; i < n; ++i) {
            double x = A.getQuick(i, i);
            A.setQuick(i, i, x + 1.0);
        }
    }

    private static void calcDiagm1(DoubleMatrix2D A, DoubleMatrix2D R) {
        int n = A.rows();
        for (int i = 0; i < n; ++i) {
            double x = A.getQuick(i, i);
            double v = Math.expm1(x);
            R.setQuick(i, i, v);
        }
    }

    static void multBand(DoubleMatrix2D A, int sa, DoubleMatrix2D B, int sb, DoubleMatrix2D C) {
        DMatrix.innerMultBand(A, sa, B, sb, C);
    }

    static void multBand(DoubleMatrix2D A, int sa, double h) {
        int n = A.rows();
        for (int i = 0; i < n; ++i) {
            int jmax = Math.min(i + sa, n - 1);
            for (int j = i; j <= jmax; ++j) {
                double z = A.getQuick(i, j);
                A.setQuick(i, j, z * h);
            }
        }
    }

    static void addMultBand(double g, DoubleMatrix2D A, int sa, double h, DoubleMatrix2D B, int sb) {
        DoubleMatrix2D S = A.copy();
        int n = A.rows();
        for (int i = 0; i < n; ++i) {
            int jmax = Math.max(i + sa, i + sb);
            jmax = Math.min(jmax, n - 1);
            for (int j = i; j <= jmax; ++j) {
                double z = g * S.getQuick(i, j) + h * B.getQuick(i, j);
                A.setQuick(i, j, z);
            }
        }
    }

    public static void copy(double[][] M, double[][] R) {
        for (int i = 0; i < M.length; ++i) {
            for (int j = 0; j < M[i].length; ++j) {
                R[i][j] = M[i][j];
            }
        }
    }

    public static String toString(double[][] M) {
        StringBuffer sb = new StringBuffer();
        sb.append("{" + PrintfFormat.NEWLINE);
        for (int i = 0; i < M.length; ++i) {
            sb.append("   { ");
            for (int j = 0; j < M[i].length; ++j) {
                sb.append(M[i][j] + " ");
                if (j >= M.length - 1) continue;
                sb.append(" ");
            }
            sb.append("}" + PrintfFormat.NEWLINE);
        }
        sb.append("}");
        return sb.toString();
    }

    public String toString() {
        return DMatrix.toString(this.mat);
    }

    public int numRows() {
        return this.r;
    }

    public int numColumns() {
        return this.c;
    }

    public double get(int row, int column) {
        if (row >= this.r || column >= this.c) {
            throw new IndexOutOfBoundsException();
        }
        return this.mat[row][column];
    }

    public void set(int row, int column, double value) {
        if (row >= this.r || column >= this.c) {
            throw new IndexOutOfBoundsException();
        }
        this.mat[row][column] = value;
    }

    public DMatrix transpose() {
        DMatrix result = new DMatrix(this.c, this.r);
        for (int i = 0; i < this.r; ++i) {
            for (int j = 0; j < this.c; ++j) {
                result.mat[j][i] = this.mat[i][j];
            }
        }
        return result;
    }
}

