/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class JDBCManager {
    public static Connection connectToDatabase(Properties prop) throws SQLException {
        Connection connection = null;
        String jndiName = prop.getProperty("jdbc.jndi-name");
        if (jndiName != null) {
            try {
                InitialContext context = new InitialContext();
                connection = ((DataSource)context.lookup(jndiName)).getConnection();
            }
            catch (NamingException e) {
                throw new IllegalArgumentException("The jdbc.jndi-name property refers to the invalid name " + jndiName);
            }
        }
        String driver = prop.getProperty("jdbc.driver");
        String uri = prop.getProperty("jdbc.uri");
        if (uri != null) {
            if (driver != null) {
                try {
                    Class<?> driverClass = Class.forName(driver);
                    if (!Driver.class.isAssignableFrom(driverClass)) {
                        throw new IllegalArgumentException("The driver name " + driver + " does not correspond to a class implementing the java.sql.Driver interface");
                    }
                    driverClass.newInstance();
                }
                catch (ClassNotFoundException cnfe) {
                    throw new IllegalArgumentException("Could not find the driver class " + driver);
                }
                catch (IllegalAccessException iae) {
                    throw new IllegalArgumentException("An illegal access prevented the instantiation of driver class " + driver);
                }
                catch (InstantiationException ie) {
                    throw new IllegalArgumentException("An instantiation exception prevented the instantiation of driver class " + driver + ": " + ie.getMessage());
                }
            }
            connection = DriverManager.getConnection(uri);
        } else {
            throw new IllegalArgumentException("The jdbc.driver and jdbc.uri properties must be given if jdbc.jndi-name is not set");
        }
        return connection;
    }

    public static Connection connectToDatabase(InputStream is) throws IOException, SQLException {
        Properties prop = new Properties();
        prop.load(is);
        return JDBCManager.connectToDatabase(prop);
    }

    public static Connection connectToDatabase(URL url) throws IOException, SQLException {
        try (InputStream is = url.openStream();){
            Connection connection = JDBCManager.connectToDatabase(is);
            return connection;
        }
    }

    public static Connection connectToDatabase(File file) throws IOException, SQLException {
        try (FileInputStream is = new FileInputStream(file);){
            Connection connection = JDBCManager.connectToDatabase(is);
            return connection;
        }
    }

    public static Connection connectToDatabase(String fileName) throws IOException, SQLException {
        try (FileInputStream is = new FileInputStream(fileName);){
            Connection connection = JDBCManager.connectToDatabase(is);
            return connection;
        }
    }

    public static Connection connectToDatabaseFromResource(String resource) throws IOException, SQLException {
        try (InputStream is = JDBCManager.class.getClassLoader().getResourceAsStream(resource);){
            Connection connection = JDBCManager.connectToDatabase(is);
            return connection;
        }
    }

    public static double[] readDoubleData(Statement stmt, String query) throws SQLException {
        ResultSet rs = stmt.executeQuery(query);
        rs.last();
        double[] res = new double[rs.getRow()];
        rs.first();
        for (int i = 0; i < res.length; ++i) {
            res[i] = rs.getDouble(1);
            rs.next();
        }
        rs.close();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] readDoubleData(Connection connection, String query) throws SQLException {
        try (Statement stmt = connection.createStatement(1004, 1007);){
            double[] dArray = JDBCManager.readDoubleData(stmt, query);
            return dArray;
        }
    }

    public static double[] readDoubleData(Statement stmt, String table, String column) throws SQLException {
        String query = "SELECT " + column + " FROM " + table;
        return JDBCManager.readDoubleData(stmt, query);
    }

    public static double[] readDoubleData(Connection connection, String table, String column) throws SQLException {
        String query = "SELECT " + column + " FROM " + table;
        return JDBCManager.readDoubleData(connection, query);
    }

    public static int[] readIntData(Statement stmt, String query) throws SQLException {
        ResultSet rs = stmt.executeQuery(query);
        rs.last();
        int[] res = new int[rs.getRow()];
        rs.first();
        for (int i = 0; i < res.length; ++i) {
            res[i] = rs.getInt(1);
            rs.next();
        }
        rs.close();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] readIntData(Connection connection, String query) throws SQLException {
        try (Statement stmt = connection.createStatement(1004, 1007);){
            int[] nArray = JDBCManager.readIntData(stmt, query);
            return nArray;
        }
    }

    public static int[] readIntData(Statement stmt, String table, String column) throws SQLException {
        String query = "SELECT " + column + " FROM " + table;
        return JDBCManager.readIntData(stmt, query);
    }

    public static int[] readIntData(Connection connection, String table, String column) throws SQLException {
        String query = "SELECT " + column + " FROM " + table;
        return JDBCManager.readIntData(connection, query);
    }

    public static Object[] readObjectData(Statement stmt, String query) throws SQLException {
        ResultSet rs = stmt.executeQuery(query);
        rs.last();
        Object[] res = new Object[rs.getRow()];
        rs.first();
        for (int i = 0; i < res.length; ++i) {
            res[i] = rs.getObject(1);
            rs.next();
        }
        rs.close();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] readObjectData(Connection connection, String query) throws SQLException {
        try (Statement stmt = connection.createStatement(1004, 1007);){
            Object[] objectArray = JDBCManager.readObjectData(stmt, query);
            return objectArray;
        }
    }

    public static Object[] readObjectData(Statement stmt, String table, String column) throws SQLException {
        String query = "SELECT " + column + " FROM " + table;
        return JDBCManager.readObjectData(stmt, query);
    }

    public static Object[] readObjectData(Connection connection, String table, String column) throws SQLException {
        String query = "SELECT " + column + " FROM " + table;
        return JDBCManager.readObjectData(connection, query);
    }

    public static double[][] readDoubleData2D(Statement stmt, String query) throws SQLException {
        ResultSet rs = stmt.executeQuery(query);
        rs.last();
        int c = rs.getMetaData().getColumnCount();
        double[][] res = new double[rs.getRow()][c];
        rs.first();
        for (int i = 0; i < res.length; ++i) {
            for (int j = 0; j < res[i].length; ++j) {
                res[i][j] = rs.getDouble(1 + j);
            }
            rs.next();
        }
        rs.close();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[][] readDoubleData2D(Connection connection, String query) throws SQLException {
        try (Statement stmt = connection.createStatement(1004, 1007);){
            double[][] dArray = JDBCManager.readDoubleData2D(stmt, query);
            return dArray;
        }
    }

    public static double[][] readDoubleData2DTable(Statement stmt, String table) throws SQLException {
        String query = "SELECT * FROM " + table;
        return JDBCManager.readDoubleData2D(stmt, query);
    }

    public static double[][] readDoubleData2DTable(Connection connection, String table) throws SQLException {
        String query = "SELECT * FROM " + table;
        return JDBCManager.readDoubleData2D(connection, query);
    }

    public static int[][] readIntData2D(Statement stmt, String query) throws SQLException {
        ResultSet rs = stmt.executeQuery(query);
        rs.last();
        int c = rs.getMetaData().getColumnCount();
        int[][] res = new int[rs.getRow()][c];
        rs.first();
        for (int i = 0; i < res.length; ++i) {
            for (int j = 0; j < res[i].length; ++j) {
                res[i][j] = rs.getInt(1 + j);
            }
            rs.next();
        }
        rs.close();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[][] readIntData2D(Connection connection, String query) throws SQLException {
        try (Statement stmt = connection.createStatement(1004, 1007);){
            int[][] nArray = JDBCManager.readIntData2D(stmt, query);
            return nArray;
        }
    }

    public static int[][] readIntData2DTable(Statement stmt, String table) throws SQLException {
        String query = "SELECT * FROM " + table;
        return JDBCManager.readIntData2D(stmt, query);
    }

    public static int[][] readIntData2DTable(Connection connection, String table) throws SQLException {
        String query = "SELECT * FROM " + table;
        return JDBCManager.readIntData2D(connection, query);
    }

    public static Object[][] readObjectData2D(Statement stmt, String query) throws SQLException {
        ResultSet rs = stmt.executeQuery(query);
        rs.last();
        int c = rs.getMetaData().getColumnCount();
        Object[][] res = new Object[rs.getRow()][c];
        rs.first();
        for (int i = 0; i < res.length; ++i) {
            for (int j = 0; j < res[i].length; ++j) {
                res[i][j] = rs.getObject(1 + j);
            }
            rs.next();
        }
        rs.close();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[][] readObjectData2D(Connection connection, String query) throws SQLException {
        try (Statement stmt = connection.createStatement(1004, 1007);){
            Object[][] objectArray = JDBCManager.readObjectData2D(stmt, query);
            return objectArray;
        }
    }

    public static Object[][] readObjectData2DTable(Statement stmt, String table) throws SQLException {
        String query = "SELECT * FROM " + table;
        return JDBCManager.readObjectData2D(stmt, query);
    }

    public static Object[][] readObjectData2DTable(Connection connection, String table) throws SQLException {
        String query = "SELECT * FROM " + table;
        return JDBCManager.readObjectData2D(connection, query);
    }
}

