/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.util;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Systeme {
    private Systeme() {
    }

    public static String getHostName() {
        String host;
        try {
            InetAddress machine = InetAddress.getLocalHost();
            host = machine.getHostName();
        }
        catch (UnknownHostException uhe) {
            host = "unknown host machine";
        }
        int j = host.indexOf(46);
        String name = j >= 0 ? host.substring(0, j) : host;
        return name;
    }

    public static String getProcessInfo() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        StackTraceElement mai = stack[stack.length - 1];
        String str = mai.getClassName();
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        Date startTime = new Date(runtime.getStartTime());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss");
        str = str + " [" + runtime.getName() + "]";
        str = str + " [" + dateFormat.format(startTime) + "]";
        return str;
    }
}

