/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.util.io;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import umontreal.ssj.util.io.DataField;
import umontreal.ssj.util.io.DataReader;

public abstract class AbstractDataReader
implements DataReader {
    @Override
    public String readString(String label) throws IOException {
        return this.readField(label).asString();
    }

    @Override
    public int readInt(String label) throws IOException {
        return this.readField(label).asInt();
    }

    @Override
    public float readFloat(String label) throws IOException {
        return this.readField(label).asFloat();
    }

    @Override
    public double readDouble(String label) throws IOException {
        return this.readField(label).asDouble();
    }

    @Override
    public String[] readStringArray(String label) throws IOException {
        return this.readField(label).asStringArray();
    }

    @Override
    public int[] readIntArray(String label) throws IOException {
        return this.readField(label).asIntArray();
    }

    @Override
    public float[] readFloatArray(String label) throws IOException {
        return this.readField(label).asFloatArray();
    }

    @Override
    public double[] readDoubleArray(String label) throws IOException {
        return this.readField(label).asDoubleArray();
    }

    @Override
    public String[][] readStringArray2D(String label) throws IOException {
        return this.readField(label).asStringArray2D();
    }

    @Override
    public int[][] readIntArray2D(String label) throws IOException {
        return this.readField(label).asIntArray2D();
    }

    @Override
    public float[][] readFloatArray2D(String label) throws IOException {
        return this.readField(label).asFloatArray2D();
    }

    @Override
    public double[][] readDoubleArray2D(String label) throws IOException {
        return this.readField(label).asDoubleArray2D();
    }

    @Override
    public Map<String, DataField> readAllNextFields() throws IOException {
        HashMap<String, DataField> fields = new HashMap<String, DataField>();
        int iAnonymous = 0;
        while (this.dataPending()) {
            DataField data = this.readNextField();
            String key = data.getLabel();
            if (key == null) {
                key = String.format("_data%02d_", ++iAnonymous);
            }
            fields.put(key, data);
        }
        return fields;
    }

    @Override
    public Map<String, DataField> readAllFields() throws IOException {
        this.reset();
        return this.readAllNextFields();
    }
}

