/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.spring.plugins.secondary;

import cloud.tianai.captcha.application.FilterImageCaptchaApplication;
import cloud.tianai.captcha.application.ImageCaptchaApplication;
import cloud.tianai.captcha.common.AnyMap;
import cloud.tianai.captcha.common.response.ApiResponse;
import cloud.tianai.captcha.spring.autoconfiguration.SecondaryVerificationProperties;
import cloud.tianai.captcha.validator.common.model.dto.ImageCaptchaTrack;
import java.util.concurrent.TimeUnit;

public class SecondaryVerificationApplication
extends FilterImageCaptchaApplication {
    private SecondaryVerificationProperties prop;

    public SecondaryVerificationApplication(ImageCaptchaApplication target, SecondaryVerificationProperties prop) {
        super(target);
        this.prop = prop;
    }

    public ApiResponse<?> matching(String id, ImageCaptchaTrack imageCaptchaTrack) {
        ApiResponse match = super.matching(id, imageCaptchaTrack);
        if (match.isSuccess()) {
            this.addSecondaryVerification(id, imageCaptchaTrack);
        }
        return match;
    }

    public boolean secondaryVerification(String id) {
        AnyMap cache = this.target.getCacheStore().getAndRemoveCache(this.getKey(id));
        return cache != null;
    }

    protected void addSecondaryVerification(String id, ImageCaptchaTrack imageCaptchaTrack) {
        this.target.getCacheStore().setCache(this.getKey(id), new AnyMap(), this.prop.getExpire(), TimeUnit.MILLISECONDS);
    }

    protected String getKey(String id) {
        return this.prop.getKeyPrefix().concat(":").concat(id);
    }
}

