/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.spring.store.impl;

import cloud.tianai.captcha.cache.CacheStore;
import cloud.tianai.captcha.common.AnyMap;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;

public class RedisCacheStore
implements CacheStore {
    private static final RedisScript<String> SCRIPT_GET_CACHE = new DefaultRedisScript("local res = redis.call('get',KEYS[1])  if res == nil  then return nil  else  redis.call('del',KEYS[1]) return res end", String.class);
    protected StringRedisTemplate redisTemplate;
    private Gson gson = new Gson();

    public RedisCacheStore(StringRedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public AnyMap getCache(String key) {
        String jsonData = (String)this.redisTemplate.opsForValue().get((Object)key);
        if (org.springframework.util.StringUtils.isEmpty((Object)jsonData)) {
            return null;
        }
        return (AnyMap)this.gson.fromJson(jsonData, new TypeToken<AnyMap>(){}.getType());
    }

    public AnyMap getAndRemoveCache(String key) {
        String json = (String)this.redisTemplate.execute(SCRIPT_GET_CACHE, Collections.singletonList(key), new Object[0]);
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        return (AnyMap)this.gson.fromJson(json, new TypeToken<AnyMap>(){}.getType());
    }

    public boolean setCache(String key, AnyMap data, Long expire, TimeUnit timeUnit) {
        this.redisTemplate.opsForValue().set((Object)key, (Object)this.gson.toJson((Object)data), expire.longValue(), timeUnit);
        return true;
    }

    public Long incr(String key, long delta, Long expire, TimeUnit timeUnit) {
        Long increment = this.redisTemplate.opsForValue().increment((Object)key, delta);
        this.redisTemplate.expire((Object)key, expire.longValue(), timeUnit);
        return increment;
    }

    public Long getLong(String key) {
        String value = (String)this.redisTemplate.opsForValue().get((Object)key);
        if (value == null) {
            return null;
        }
        return Long.valueOf(value);
    }
}

