/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.dao.alone;

import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.dao.SaTokenDaoDefaultImpl;
import cn.dev33.satoken.dao.SaTokenDaoRedis;
import cn.dev33.satoken.dao.SaTokenDaoRedisJackson;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;

@Configuration
public class SaAloneRedisInject
implements EnvironmentAware {
    public static final String ALONE_PREFIX = "sa-token.alone-redis";
    @Autowired(required=false)
    public SaTokenDao saTokenDao;

    public void setEnvironment(Environment environment) {
        try {
            if (this.saTokenDao == null || this.saTokenDao instanceof SaTokenDaoDefaultImpl) {
                return;
            }
            if (environment.getProperty("sa-token.alone-redis.host") == null) {
                return;
            }
            RedisProperties cfg = (RedisProperties)Binder.get((Environment)environment).bind(ALONE_PREFIX, RedisProperties.class).get();
            RedisStandaloneConfiguration redisConfig = new RedisStandaloneConfiguration();
            redisConfig.setHostName(cfg.getHost());
            redisConfig.setPort(cfg.getPort());
            redisConfig.setDatabase(cfg.getDatabase());
            redisConfig.setPassword(RedisPassword.of((String)cfg.getPassword()));
            GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
            RedisProperties.Lettuce lettuce = cfg.getLettuce();
            if (lettuce.getPool() != null) {
                RedisProperties.Pool pool = cfg.getLettuce().getPool();
                poolConfig.setMaxTotal(pool.getMaxActive());
                poolConfig.setMaxIdle(pool.getMaxIdle());
                poolConfig.setMinIdle(pool.getMinIdle());
                poolConfig.setMaxWaitMillis(pool.getMaxWait().toMillis());
            }
            LettucePoolingClientConfiguration.LettucePoolingClientConfigurationBuilder builder = LettucePoolingClientConfiguration.builder();
            if (cfg.getTimeout() != null) {
                builder.commandTimeout(cfg.getTimeout());
            }
            if (lettuce.getShutdownTimeout() != null) {
                builder.shutdownTimeout(lettuce.getShutdownTimeout());
            }
            LettucePoolingClientConfiguration clientConfig = builder.poolConfig(poolConfig).build();
            LettuceConnectionFactory factory = new LettuceConnectionFactory(redisConfig, (LettuceClientConfiguration)clientConfig);
            factory.afterPropertiesSet();
            try {
                Class.forName("cn.dev33.satoken.dao.SaTokenDaoRedis");
                SaTokenDaoRedis dao = (SaTokenDaoRedis)this.saTokenDao;
                dao.isInit = false;
                dao.init((RedisConnectionFactory)factory);
                return;
            }
            catch (ClassNotFoundException dao) {
                try {
                    Class.forName("cn.dev33.satoken.dao.SaTokenDaoRedisJackson");
                    SaTokenDaoRedisJackson dao2 = (SaTokenDaoRedisJackson)this.saTokenDao;
                    dao2.isInit = false;
                    dao2.init((RedisConnectionFactory)factory);
                    return;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @ConfigurationProperties(prefix="sa-token.alone-redis")
    public RedisProperties getSaAloneRedisConfig() {
        return new RedisProperties();
    }
}

