/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.plugin;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.exception.SaTokenPluginException;
import cn.dev33.satoken.fun.hooks.SaTokenPluginHookFunction;
import cn.dev33.satoken.plugin.SaTokenPlugin;
import cn.dev33.satoken.plugin.SaTokenPluginHookModel;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class SaTokenPluginHolder {
    public static SaTokenPluginHolder instance = new SaTokenPluginHolder();
    public boolean isLoader = false;
    public String spiDir = "satoken";
    private final List<SaTokenPlugin> pluginList = new ArrayList<SaTokenPlugin>();
    private final List<SaTokenPluginHookModel<? extends SaTokenPlugin>> installHooks = new ArrayList<SaTokenPluginHookModel<? extends SaTokenPlugin>>();
    private final List<SaTokenPluginHookModel<? extends SaTokenPlugin>> beforeInstallHooks = new ArrayList<SaTokenPluginHookModel<? extends SaTokenPlugin>>();
    private final List<SaTokenPluginHookModel<? extends SaTokenPlugin>> afterInstallHooks = new ArrayList<SaTokenPluginHookModel<? extends SaTokenPlugin>>();
    private final List<SaTokenPluginHookModel<? extends SaTokenPlugin>> destroyHooks = new ArrayList<SaTokenPluginHookModel<? extends SaTokenPlugin>>();
    private final List<SaTokenPluginHookModel<? extends SaTokenPlugin>> beforeDestroyHooks = new ArrayList<SaTokenPluginHookModel<? extends SaTokenPlugin>>();
    private final List<SaTokenPluginHookModel<? extends SaTokenPlugin>> afterDestroyHooks = new ArrayList<SaTokenPluginHookModel<? extends SaTokenPlugin>>();

    public synchronized void init() {
        if (this.isLoader) {
            return;
        }
        this.loaderPlugins();
        this.isLoader = true;
    }

    public synchronized void loaderPlugins() {
        SaManager.getLog().info("SPI plugin loading start ...", new Object[0]);
        List<SaTokenPlugin> plugins = this._loaderPluginsBySpi(SaTokenPlugin.class, this.spiDir);
        for (SaTokenPlugin plugin : plugins) {
            this.installPlugin(plugin);
        }
        SaManager.getLog().info("SPI plugin loading end ...", new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T> List<T> _loaderPluginsBySpi(Class<T> serviceInterface, String dirName) {
        String path = "META-INF/" + dirName + "/" + serviceInterface.getName();
        ArrayList<T> providers = new ArrayList<T>();
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> resources = classLoader.getResources(path);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                try {
                    InputStream is = url.openStream();
                    try {
                        String line;
                        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                        while ((line = reader.readLine()) != null) {
                            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                            Class<?> clazz = Class.forName(line, true, classLoader);
                            T instance = serviceInterface.cast(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                            providers.add(instance);
                        }
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (Exception e) {
                    throw new SaTokenPluginException("SPI \u63d2\u4ef6\u52a0\u8f7d\u5931\u8d25: " + e.getMessage(), e);
                    return providers;
                }
            }
        }
        catch (Exception e) {
            throw new SaTokenPluginException("SPI \u63d2\u4ef6\u52a0\u8f7d\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public synchronized List<SaTokenPlugin> getPluginListCopy() {
        return new ArrayList<SaTokenPlugin>(this.pluginList);
    }

    public synchronized <T extends SaTokenPlugin> boolean isInstalledPlugin(Class<T> pluginClass) {
        for (SaTokenPlugin plugin : this.pluginList) {
            if (!plugin.getClass().equals(pluginClass)) continue;
            return true;
        }
        return false;
    }

    public synchronized <T extends SaTokenPlugin> T getPlugin(Class<T> pluginClass) {
        for (SaTokenPlugin plugin : this.pluginList) {
            if (!plugin.getClass().equals(pluginClass)) continue;
            return (T)plugin;
        }
        return null;
    }

    protected synchronized <T extends SaTokenPlugin> int _consumeHooks(List<SaTokenPluginHookModel<? extends SaTokenPlugin>> hooks, Class<T> pluginClass) {
        int consumeCount = 0;
        for (int i = 0; i < hooks.size(); ++i) {
            SaTokenPluginHookModel<? extends SaTokenPlugin> model = hooks.get(i);
            if (!model.listenerClass.equals(pluginClass)) continue;
            model.executeFunction.execute((SaTokenPlugin)this.getPlugin(pluginClass));
            hooks.remove(i);
            --i;
            ++consumeCount;
        }
        return consumeCount;
    }

    public synchronized SaTokenPluginHolder installPlugin(SaTokenPlugin plugin) {
        if (plugin == null) {
            throw new SaTokenPluginException("\u63d2\u4ef6\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (this.isInstalledPlugin(plugin.getClass())) {
            throw new SaTokenPluginException("\u63d2\u4ef6 [ " + plugin.getClass().getCanonicalName() + " ] \u5df2\u5b89\u88c5\uff0c\u4e0d\u53ef\u91cd\u590d\u5b89\u88c5");
        }
        this._consumeHooks(this.beforeInstallHooks, plugin.getClass());
        int consumeCount = this._consumeHooks(this.installHooks, plugin.getClass());
        if (consumeCount == 0) {
            plugin.install();
        }
        this._consumeHooks(this.afterInstallHooks, plugin.getClass());
        this.pluginList.add(plugin);
        return this;
    }

    public synchronized <T extends SaTokenPlugin> SaTokenPluginHolder installPlugin(Class<T> pluginClass) {
        try {
            SaTokenPlugin plugin = (SaTokenPlugin)pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return this.installPlugin(plugin);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new SaTokenPluginException(e);
        }
    }

    public synchronized SaTokenPluginHolder destroyPlugin(SaTokenPlugin plugin) {
        if (plugin == null) {
            throw new SaTokenPluginException("\u63d2\u4ef6\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (!this.isInstalledPlugin(plugin.getClass())) {
            throw new SaTokenPluginException("\u63d2\u4ef6 [ " + plugin.getClass().getCanonicalName() + " ] \u672a\u5b89\u88c5\uff0c\u65e0\u6cd5\u5378\u8f7d");
        }
        this._consumeHooks(this.beforeDestroyHooks, plugin.getClass());
        int consumeCount = this._consumeHooks(this.destroyHooks, plugin.getClass());
        if (consumeCount == 0) {
            plugin.destroy();
        }
        this._consumeHooks(this.afterDestroyHooks, plugin.getClass());
        return this;
    }

    public synchronized <T extends SaTokenPlugin> SaTokenPluginHolder destroyPlugin(Class<T> pluginClass) {
        return this.destroyPlugin((SaTokenPlugin)this.getPlugin(pluginClass));
    }

    public synchronized <T extends SaTokenPlugin> SaTokenPluginHolder onInstall(Class<T> listenerClass, SaTokenPluginHookFunction<T> executeFunction) {
        if (this.isInstalledPlugin(listenerClass)) {
            throw new SaTokenPluginException("\u63d2\u4ef6 [ " + listenerClass.getCanonicalName() + " ] \u5df2\u5b89\u88c5\u5b8c\u6bd5\uff0c\u4e0d\u5141\u8bb8\u518d\u6ce8\u518c Install \u94a9\u5b50\u51fd\u6570");
        }
        this.installHooks.add(new SaTokenPluginHookModel<T>(listenerClass, executeFunction));
        return this;
    }

    public synchronized <T extends SaTokenPlugin> SaTokenPluginHolder onBeforeInstall(Class<T> listenerClass, SaTokenPluginHookFunction<T> executeFunction) {
        if (this.isInstalledPlugin(listenerClass)) {
            throw new SaTokenPluginException("\u63d2\u4ef6 [ " + listenerClass.getCanonicalName() + " ] \u5df2\u5b89\u88c5\u5b8c\u6bd5\uff0c\u4e0d\u5141\u8bb8\u518d\u6ce8\u518c Install \u524d\u7f6e\u94a9\u5b50\u51fd\u6570");
        }
        this.beforeInstallHooks.add(new SaTokenPluginHookModel<T>(listenerClass, executeFunction));
        return this;
    }

    public synchronized <T extends SaTokenPlugin> SaTokenPluginHolder onAfterInstall(Class<T> listenerClass, SaTokenPluginHookFunction<T> executeFunction) {
        if (this.isInstalledPlugin(listenerClass)) {
            executeFunction.execute((SaTokenPlugin)this.getPlugin(listenerClass));
            return this;
        }
        this.afterInstallHooks.add(new SaTokenPluginHookModel<T>(listenerClass, executeFunction));
        return this;
    }

    public synchronized <T extends SaTokenPlugin> SaTokenPluginHolder onDestroy(Class<T> listenerClass, SaTokenPluginHookFunction<T> executeFunction) {
        this.destroyHooks.add(new SaTokenPluginHookModel<T>(listenerClass, executeFunction));
        return this;
    }

    public synchronized <T extends SaTokenPlugin> SaTokenPluginHolder onBeforeDestroy(Class<T> listenerClass, SaTokenPluginHookFunction<T> executeFunction) {
        this.beforeDestroyHooks.add(new SaTokenPluginHookModel<T>(listenerClass, executeFunction));
        return this;
    }

    public synchronized <T extends SaTokenPlugin> SaTokenPluginHolder onAfterDestroy(Class<T> listenerClass, SaTokenPluginHookFunction<T> executeFunction) {
        this.afterDestroyHooks.add(new SaTokenPluginHookModel<T>(listenerClass, executeFunction));
        return this;
    }
}

