/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.oauth2.dao;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.config.SaTokenConfig;
import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.fun.SaParamFunction;
import cn.dev33.satoken.oauth2.SaOAuth2Manager;
import cn.dev33.satoken.oauth2.data.model.AccessTokenModel;
import cn.dev33.satoken.oauth2.data.model.ClientTokenModel;
import cn.dev33.satoken.oauth2.data.model.CodeModel;
import cn.dev33.satoken.oauth2.data.model.RefreshTokenModel;
import cn.dev33.satoken.oauth2.template.SaOAuth2Util;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.session.raw.SaRawSessionDelegator;
import cn.dev33.satoken.util.SaFoxUtil;
import cn.dev33.satoken.util.SaTtlMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SaOAuth2Dao
implements SaTtlMethods {
    public SaRawSessionDelegator oauth2RSD = new SaRawSessionDelegator("oauth2");
    public static final String ACCESS_TOKEN_MAP = "__HD_ACCESS_TOKEN_MAP";
    public static final String REFRESH_TOKEN_MAP = "__HD_REFRESH_TOKEN_MAP";
    public static final String CLIENT_TOKEN_MAP = "__HD_CLIENT_TOKEN_MAP";

    protected SaSession getRawSessionByAccessToken(String clientId, Object loginId, boolean isCreate) {
        String value = this.splicingAccessTokenRSDValue(clientId, loginId);
        return this.oauth2RSD.getSessionById((Object)value, isCreate);
    }

    protected SaSession getRawSessionByRefreshToken(String clientId, Object loginId, boolean isCreate) {
        String value = this.splicingRefreshTokenRSDValue(clientId, loginId);
        return this.oauth2RSD.getSessionById((Object)value, isCreate);
    }

    protected SaSession getRawSessionByClientToken(String clientId, boolean isCreate) {
        String value = this.splicingClientTokenRSDValue(clientId);
        return this.oauth2RSD.getSessionById((Object)value, isCreate);
    }

    protected void addTokenIndex_AndAdjust(SaSession session, String tokenIndexMapSaveKey, String token, long timeout, int maxTokenCount, SaParamFunction<String> removeFun) {
        Map<String, Long> tokenIndexMap = (Map<String, Long>)session.get(tokenIndexMapSaveKey, () -> ((SaOAuth2Dao)this).newTokenIndexMap());
        if (!tokenIndexMap.containsKey(token)) {
            tokenIndexMap.put(token, this.ttlToExpireTime(timeout));
            tokenIndexMap = this._removeExpiredIndex(tokenIndexMap);
            tokenIndexMap = this._removeOverflowIndex(tokenIndexMap, maxTokenCount, removeFun);
            session.set(tokenIndexMapSaveKey, tokenIndexMap);
            long maxTtl = this.getMaxTtlByExpireTime(tokenIndexMap.values());
            if (maxTtl != 0L) {
                session.updateTimeout(maxTtl);
            }
        }
    }

    protected void deleteTokenIndex_AndTryLogout(SaSession session, String tokenIndexMapSaveKey, String token) {
        Map tokenIndexMap = (Map)session.get(tokenIndexMapSaveKey, () -> ((SaOAuth2Dao)this).newTokenIndexMap());
        tokenIndexMap.remove(token);
        if (!tokenIndexMap.isEmpty()) {
            session.set(tokenIndexMapSaveKey, (Object)tokenIndexMap);
        } else {
            session.logout();
        }
    }

    protected Map<String, Long> _removeExpiredIndex(Map<String, Long> tokenIndexMap) {
        Map newTokenList = this.newTokenIndexMap();
        for (Map.Entry<String, Long> entry : tokenIndexMap.entrySet()) {
            long ttl = this.expireTimeToTtl(entry.getValue());
            if (ttl == -2L) continue;
            newTokenList.put(entry.getKey(), entry.getValue());
        }
        return newTokenList;
    }

    protected Map<String, Long> _removeOverflowIndex(Map<String, Long> tokenIndexMap, int maxTokenCount, SaParamFunction<String> removeFun) {
        if (tokenIndexMap.size() <= maxTokenCount || (long)maxTokenCount == -1L) {
            return tokenIndexMap;
        }
        Map newTokenIndexMap = this.newTokenIndexMap();
        int overflowCount = tokenIndexMap.size() - maxTokenCount;
        int removedCount = 0;
        for (Map.Entry<String, Long> entry : tokenIndexMap.entrySet()) {
            String token = entry.getKey();
            if (removedCount < overflowCount) {
                removeFun.run((Object)token);
                ++removedCount;
                continue;
            }
            newTokenIndexMap.put(token, entry.getValue());
        }
        return newTokenIndexMap;
    }

    protected Map<String, Long> getTokenIndexMap_FromAdjustAfter(SaSession session, String tokenIndexMapSaveKey) {
        if (session == null) {
            return this.newTokenIndexMap();
        }
        Map tokenIndexMap = (Map)session.get(tokenIndexMapSaveKey, () -> ((SaOAuth2Dao)this).newTokenIndexMap());
        Map<String, Long> newTokenIndexMap = this._removeExpiredIndex(tokenIndexMap);
        if (newTokenIndexMap.isEmpty()) {
            session.logout();
            return this.newTokenIndexMap();
        }
        if (tokenIndexMap.size() > newTokenIndexMap.size()) {
            session.set(tokenIndexMapSaveKey, newTokenIndexMap);
        }
        return newTokenIndexMap;
    }

    protected List<String> getTokenValueList_FromAdjustAfter(SaSession session, String tokenIndexMapSaveKey) {
        return new ArrayList<String>(this.getTokenIndexMap_FromAdjustAfter(session, tokenIndexMapSaveKey).keySet());
    }

    public void saveCode(CodeModel c) {
        if (c == null) {
            return;
        }
        this.getSaTokenDao().setObject(this.splicingCodeSaveKey(c.code), (Object)c, SaOAuth2Manager.getServerConfig().getCodeTimeout());
    }

    public void deleteCode(String code) {
        if (code != null) {
            this.getSaTokenDao().deleteObject(this.splicingCodeSaveKey(code));
        }
    }

    public CodeModel getCode(String code) {
        if (code == null) {
            return null;
        }
        return (CodeModel)this.getSaTokenDao().getObject(this.splicingCodeSaveKey(code));
    }

    public void saveCodeIndex(CodeModel c) {
        if (c == null) {
            return;
        }
        this.getSaTokenDao().set(this.splicingCodeIndexKey(c.clientId, c.loginId), c.code, SaOAuth2Manager.getServerConfig().getCodeTimeout());
    }

    public void deleteCodeIndex(String clientId, Object loginId) {
        this.getSaTokenDao().delete(this.splicingCodeIndexKey(clientId, loginId));
    }

    public String getCodeValue(String clientId, Object loginId) {
        return this.getSaTokenDao().get(this.splicingCodeIndexKey(clientId, loginId));
    }

    public void saveAccessToken(AccessTokenModel at) {
        if (at == null) {
            return;
        }
        this.getSaTokenDao().setObject(this.splicingAccessTokenSaveKey(at.accessToken), (Object)at, at.getExpiresIn());
    }

    public void deleteAccessToken(String accessToken) {
        if (accessToken != null) {
            this.getSaTokenDao().deleteObject(this.splicingAccessTokenSaveKey(accessToken));
        }
    }

    public AccessTokenModel getAccessToken(String accessToken) {
        if (accessToken == null) {
            return null;
        }
        return (AccessTokenModel)this.getSaTokenDao().getObject(this.splicingAccessTokenSaveKey(accessToken));
    }

    public void saveAccessTokenIndex_AndAdjust(AccessTokenModel at, int maxAccessTokenCount) {
        if (at == null) {
            return;
        }
        SaSession session = this.getRawSessionByAccessToken(at.clientId, at.loginId, true);
        this.addTokenIndex_AndAdjust(session, ACCESS_TOKEN_MAP, at.accessToken, at.getExpiresIn(), maxAccessTokenCount, (SaParamFunction<String>)((SaParamFunction)this::deleteAccessToken));
    }

    public void deleteAccessTokenIndex_BySingleData(String clientId, Object loginId, String accessToken) {
        SaSession session = this.getRawSessionByAccessToken(clientId, loginId, false);
        if (session == null) {
            return;
        }
        this.deleteTokenIndex_AndTryLogout(session, ACCESS_TOKEN_MAP, accessToken);
    }

    public void deleteAccessTokenIndex(String clientId, Object loginId) {
        this.oauth2RSD.deleteSessionById((Object)this.splicingAccessTokenRSDValue(clientId, loginId));
    }

    public Map<String, Long> getAccessTokenIndexMap_FromAdjustAfter(String clientId, Object loginId) {
        SaSession session = this.getRawSessionByAccessToken(clientId, loginId, false);
        return this.getTokenIndexMap_FromAdjustAfter(session, ACCESS_TOKEN_MAP);
    }

    public List<String> getAccessTokenValueList_FromAdjustAfter(String clientId, Object loginId) {
        SaSession session = this.getRawSessionByAccessToken(clientId, loginId, false);
        return this.getTokenValueList_FromAdjustAfter(session, ACCESS_TOKEN_MAP);
    }

    public void saveRefreshToken(RefreshTokenModel rt) {
        if (rt == null) {
            return;
        }
        this.getSaTokenDao().setObject(this.splicingRefreshTokenSaveKey(rt.refreshToken), (Object)rt, rt.getExpiresIn());
    }

    public void deleteRefreshToken(String refreshToken) {
        if (refreshToken != null) {
            this.getSaTokenDao().deleteObject(this.splicingRefreshTokenSaveKey(refreshToken));
        }
    }

    public RefreshTokenModel getRefreshToken(String refreshToken) {
        if (refreshToken == null) {
            return null;
        }
        return (RefreshTokenModel)this.getSaTokenDao().getObject(this.splicingRefreshTokenSaveKey(refreshToken));
    }

    public void saveRefreshTokenIndex_AndAdjust(RefreshTokenModel rt, int maxRefreshTokenCount) {
        if (rt == null) {
            return;
        }
        SaSession session = this.getRawSessionByRefreshToken(rt.clientId, rt.loginId, true);
        this.addTokenIndex_AndAdjust(session, REFRESH_TOKEN_MAP, rt.refreshToken, rt.getExpiresIn(), maxRefreshTokenCount, (SaParamFunction<String>)((SaParamFunction)this::deleteRefreshToken));
    }

    public void deleteRefreshTokenIndex_BySingleData(String clientId, Object loginId, String refreshToken) {
        SaSession session = this.getRawSessionByRefreshToken(clientId, loginId, false);
        if (session == null) {
            return;
        }
        this.deleteTokenIndex_AndTryLogout(session, REFRESH_TOKEN_MAP, refreshToken);
    }

    public void deleteRefreshTokenIndex(String clientId, Object loginId) {
        this.oauth2RSD.deleteSessionById((Object)this.splicingRefreshTokenRSDValue(clientId, loginId));
    }

    public Map<String, Long> getRefreshTokenIndexMap_FromAdjustAfter(String clientId, Object loginId) {
        SaSession session = this.getRawSessionByRefreshToken(clientId, loginId, false);
        return this.getTokenIndexMap_FromAdjustAfter(session, REFRESH_TOKEN_MAP);
    }

    public List<String> getRefreshTokenValueList_FromAdjustAfter(String clientId, Object loginId) {
        SaSession session = this.getRawSessionByRefreshToken(clientId, loginId, false);
        return this.getTokenValueList_FromAdjustAfter(session, REFRESH_TOKEN_MAP);
    }

    public void saveClientToken(ClientTokenModel ct) {
        if (ct == null) {
            return;
        }
        this.getSaTokenDao().setObject(this.splicingClientTokenSaveKey(ct.clientToken), (Object)ct, ct.getExpiresIn());
    }

    public void deleteClientToken(String clientToken) {
        if (clientToken != null) {
            this.getSaTokenDao().deleteObject(this.splicingClientTokenSaveKey(clientToken));
        }
    }

    public ClientTokenModel getClientToken(String clientToken) {
        if (clientToken == null) {
            return null;
        }
        return (ClientTokenModel)this.getSaTokenDao().getObject(this.splicingClientTokenSaveKey(clientToken));
    }

    public void saveClientTokenIndex_AndAdjust(ClientTokenModel ct, int maxClientTokenCount) {
        if (ct == null) {
            return;
        }
        SaSession session = this.getRawSessionByClientToken(ct.clientId, true);
        this.addTokenIndex_AndAdjust(session, CLIENT_TOKEN_MAP, ct.clientToken, ct.getExpiresIn(), maxClientTokenCount, (SaParamFunction<String>)((SaParamFunction)this::deleteClientToken));
    }

    public void deleteClientTokenIndex_BySingleData(String clientId, String clientToken) {
        SaSession session = this.getRawSessionByClientToken(clientId, false);
        if (session == null) {
            return;
        }
        this.deleteTokenIndex_AndTryLogout(session, CLIENT_TOKEN_MAP, clientToken);
    }

    public void deleteClientTokenIndex(String clientId) {
        this.oauth2RSD.deleteSessionById((Object)this.splicingClientTokenRSDValue(clientId));
    }

    public Map<String, Long> getClientTokenIndexMap_FromAdjustAfter(String clientId, Object loginId) {
        SaSession session = this.getRawSessionByClientToken(clientId, false);
        return this.getTokenIndexMap_FromAdjustAfter(session, CLIENT_TOKEN_MAP);
    }

    public List<String> getClientTokenValueList_FromAdjustAfter(String clientId) {
        SaSession session = this.getRawSessionByClientToken(clientId, false);
        return this.getTokenValueList_FromAdjustAfter(session, CLIENT_TOKEN_MAP);
    }

    public void saveGrantScope(String clientId, Object loginId, List<String> scopes) {
        if (!SaFoxUtil.isEmpty(scopes)) {
            long ttl = SaOAuth2Util.checkClientModel(clientId).getAccessTokenTimeout();
            String value = SaOAuth2Manager.getDataConverter().convertScopeListToString(scopes);
            this.getSaTokenDao().set(this.splicingGrantScopeKey(clientId, loginId), value, ttl);
        }
    }

    public void deleteGrantScope(String clientId, Object loginId) {
        this.getSaTokenDao().delete(this.splicingGrantScopeKey(clientId, loginId));
    }

    public List<String> getGrantScope(String clientId, Object loginId) {
        String value = this.getSaTokenDao().get(this.splicingGrantScopeKey(clientId, loginId));
        return SaOAuth2Manager.getDataConverter().convertScopeStringToList(value);
    }

    public void saveState(String state) {
        if (!SaFoxUtil.isEmpty((Object)state)) {
            long ttl = SaOAuth2Manager.getServerConfig().getCodeTimeout();
            this.getSaTokenDao().set(this.splicingStateSaveKey(state), state, ttl);
        }
    }

    public void deleteState(String state) {
        this.getSaTokenDao().delete(this.splicingStateSaveKey(state));
    }

    public String getState(String state) {
        if (SaFoxUtil.isEmpty((Object)state)) {
            return null;
        }
        return this.getSaTokenDao().get(this.splicingStateSaveKey(state));
    }

    public void saveCodeNonceIndex(CodeModel c) {
        if (c == null || SaFoxUtil.isEmpty((Object)c.nonce)) {
            return;
        }
        this.getSaTokenDao().set(this.splicingCodeNonceIndexSaveKey(c.code), c.nonce, SaOAuth2Manager.getServerConfig().getCodeTimeout());
    }

    public String getNonce(String code) {
        if (SaFoxUtil.isEmpty((Object)code)) {
            return null;
        }
        return this.getSaTokenDao().get(this.splicingCodeNonceIndexSaveKey(code));
    }

    public String splicingCodeSaveKey(String code) {
        return this.getSaTokenConfig().getTokenName() + ":oauth2:code:" + code;
    }

    public String splicingCodeIndexKey(String clientId, Object loginId) {
        return this.getSaTokenConfig().getTokenName() + ":oauth2:code-index:" + clientId + ":" + loginId;
    }

    public String splicingAccessTokenSaveKey(String accessToken) {
        return this.getSaTokenConfig().getTokenName() + ":oauth2:access-token:" + accessToken;
    }

    public String splicingAccessTokenRSDValue(String clientId, Object loginId) {
        return "access-token:" + clientId + ":" + loginId;
    }

    public String splicingRefreshTokenSaveKey(String refreshToken) {
        return this.getSaTokenConfig().getTokenName() + ":oauth2:refresh-token:" + refreshToken;
    }

    public String splicingRefreshTokenRSDValue(String clientId, Object loginId) {
        return "refresh-token:" + clientId + ":" + loginId;
    }

    public String splicingClientTokenSaveKey(String clientToken) {
        return this.getSaTokenConfig().getTokenName() + ":oauth2:client-token:" + clientToken;
    }

    public String splicingClientTokenRSDValue(String clientId) {
        return "client-token:" + clientId;
    }

    public String splicingGrantScopeKey(String clientId, Object loginId) {
        return this.getSaTokenConfig().getTokenName() + ":oauth2:grant-scope:" + clientId + ":" + loginId;
    }

    public String splicingStateSaveKey(String state) {
        return this.getSaTokenConfig().getTokenName() + ":oauth2:state:" + state;
    }

    public String splicingCodeNonceIndexSaveKey(String code) {
        return this.getSaTokenConfig().getTokenName() + ":oauth2:code-nonce-index:" + code;
    }

    public SaTokenDao getSaTokenDao() {
        return SaManager.getSaTokenDao();
    }

    public SaTokenConfig getSaTokenConfig() {
        return SaManager.getConfig();
    }
}

