/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.oauth2.data.generate;

import cn.dev33.satoken.oauth2.SaOAuth2Manager;
import cn.dev33.satoken.oauth2.consts.SaOAuth2Consts;
import cn.dev33.satoken.oauth2.dao.SaOAuth2Dao;
import cn.dev33.satoken.oauth2.data.convert.SaOAuth2DataConverter;
import cn.dev33.satoken.oauth2.data.generate.SaOAuth2DataGenerate;
import cn.dev33.satoken.oauth2.data.model.AccessTokenModel;
import cn.dev33.satoken.oauth2.data.model.ClientTokenModel;
import cn.dev33.satoken.oauth2.data.model.CodeModel;
import cn.dev33.satoken.oauth2.data.model.RefreshTokenModel;
import cn.dev33.satoken.oauth2.data.model.loader.SaClientModel;
import cn.dev33.satoken.oauth2.data.model.request.RequestAuthModel;
import cn.dev33.satoken.oauth2.exception.SaOAuth2AuthorizationCodeException;
import cn.dev33.satoken.oauth2.exception.SaOAuth2Exception;
import cn.dev33.satoken.oauth2.exception.SaOAuth2RefreshTokenException;
import cn.dev33.satoken.oauth2.strategy.SaOAuth2Strategy;
import cn.dev33.satoken.util.SaFoxUtil;
import cn.dev33.satoken.util.SaTtlMethods;
import java.util.List;
import java.util.function.Consumer;

public class SaOAuth2DataGenerateDefaultImpl
implements SaOAuth2DataGenerate,
SaTtlMethods {
    @Override
    public CodeModel generateCode(RequestAuthModel ra) {
        SaOAuth2Dao dao = SaOAuth2Manager.getDao();
        dao.deleteCode(dao.getCodeValue(ra.clientId, ra.loginId));
        CodeModel cm = SaOAuth2Manager.getDataConverter().convertRequestAuthToCode(ra);
        dao.saveCode(cm);
        dao.saveCodeIndex(cm);
        dao.saveCodeNonceIndex(cm);
        return cm;
    }

    @Override
    public AccessTokenModel generateAccessToken(String code) {
        SaOAuth2Dao dao = SaOAuth2Manager.getDao();
        SaOAuth2DataConverter dataConverter = SaOAuth2Manager.getDataConverter();
        CodeModel cm = dao.getCode(code);
        SaOAuth2AuthorizationCodeException.throwBy(cm == null, "\u65e0\u6548 code: " + code, code, 30110);
        SaOAuth2Strategy.instance.userAuthorizeClientCheck.run(cm.loginId, (Object)cm.clientId);
        SaClientModel clientModel = SaOAuth2Manager.getDataLoader().getClientModelNotNull(cm.clientId);
        AccessTokenModel at = dataConverter.convertCodeToAccessToken(cm, clientModel.getAccessTokenTimeout());
        SaOAuth2Strategy.instance.workAccessTokenByScope.accept(at);
        RefreshTokenModel rt = dataConverter.convertAccessTokenToRefreshToken(at, clientModel.getRefreshTokenTimeout());
        at.refreshToken = rt.refreshToken;
        at.refreshExpiresTime = rt.expiresTime;
        dao.saveAccessToken(at);
        dao.saveAccessTokenIndex_AndAdjust(at, clientModel.getMaxAccessTokenCount());
        dao.saveRefreshToken(rt);
        dao.saveRefreshTokenIndex_AndAdjust(rt, clientModel.getMaxRefreshTokenCount());
        dao.deleteCode(code);
        dao.deleteCodeIndex(cm.clientId, cm.loginId);
        return at;
    }

    @Override
    public AccessTokenModel refreshAccessToken(String refreshToken) {
        SaOAuth2Dao dao = SaOAuth2Manager.getDao();
        RefreshTokenModel rt = dao.getRefreshToken(refreshToken);
        SaOAuth2RefreshTokenException.throwBy(rt == null, "\u65e0\u6548 refresh_token: " + refreshToken, refreshToken, 30111);
        SaOAuth2Strategy.instance.userAuthorizeClientCheck.run(rt.loginId, (Object)rt.clientId);
        SaClientModel clientModel = SaOAuth2Manager.getDataLoader().getClientModelNotNull(rt.clientId);
        if (clientModel.getIsNewRefresh().booleanValue()) {
            rt = SaOAuth2Manager.getDataConverter().convertRefreshTokenToRefreshToken(rt, clientModel.getRefreshTokenTimeout());
            dao.saveRefreshToken(rt);
            dao.saveRefreshTokenIndex_AndAdjust(rt, clientModel.getMaxRefreshTokenCount());
        }
        AccessTokenModel at = SaOAuth2Manager.getDataConverter().convertRefreshTokenToAccessToken(rt, clientModel.getAccessTokenTimeout());
        SaOAuth2Strategy.instance.refreshAccessTokenWorkByScope.accept(at);
        dao.saveAccessToken(at);
        dao.saveAccessTokenIndex_AndAdjust(at, clientModel.getMaxAccessTokenCount());
        return at;
    }

    @Override
    public AccessTokenModel generateAccessToken(RequestAuthModel ra, boolean isCreateRt, Consumer<AccessTokenModel> appendWork) {
        SaOAuth2Dao dao = SaOAuth2Manager.getDao();
        SaOAuth2DataConverter dataConverter = SaOAuth2Manager.getDataConverter();
        SaOAuth2Strategy.instance.userAuthorizeClientCheck.run(ra.loginId, (Object)ra.clientId);
        SaClientModel clientModel = SaOAuth2Manager.getDataLoader().getClientModelNotNull(ra.clientId);
        AccessTokenModel at = dataConverter.convertRequestAuthToAccessToken(ra, clientModel.getAccessTokenTimeout());
        if (appendWork != null) {
            appendWork.accept(at);
        }
        SaOAuth2Strategy.instance.workAccessTokenByScope.accept(at);
        if (isCreateRt) {
            RefreshTokenModel rt = dataConverter.convertAccessTokenToRefreshToken(at, clientModel.getRefreshTokenTimeout());
            at.refreshToken = rt.refreshToken;
            at.refreshExpiresTime = rt.expiresTime;
            dao.saveRefreshToken(rt);
            dao.saveRefreshTokenIndex_AndAdjust(rt, clientModel.getMaxRefreshTokenCount());
        }
        dao.saveAccessToken(at);
        dao.saveAccessTokenIndex_AndAdjust(at, clientModel.getMaxAccessTokenCount());
        return at;
    }

    @Override
    public ClientTokenModel generateClientToken(String clientId, List<String> scopes) {
        SaOAuth2Dao dao = SaOAuth2Manager.getDao();
        SaClientModel clientModel = SaOAuth2Manager.getDataLoader().getClientModelNotNull(clientId);
        ClientTokenModel ct = SaOAuth2Manager.getDataConverter().convertSaClientToClientToken(clientModel, scopes);
        SaOAuth2Strategy.instance.workClientTokenByScope.accept(ct);
        dao.saveClientToken(ct);
        dao.saveClientTokenIndex_AndAdjust(ct, clientModel.getMaxClientTokenCount());
        return ct;
    }

    @Override
    public String buildRedirectUri(String redirectUri, String code, String state) {
        String url = SaFoxUtil.joinParam((String)redirectUri, (String)SaOAuth2Consts.Param.code, (Object)code);
        if (!SaFoxUtil.isEmpty((Object)state)) {
            this.checkState(state);
            url = SaFoxUtil.joinParam((String)url, (String)SaOAuth2Consts.Param.state, (Object)state);
        }
        return url;
    }

    @Override
    public String buildImplicitRedirectUri(String redirectUri, String token, String state) {
        String url = SaFoxUtil.joinSharpParam((String)redirectUri, (String)SaOAuth2Consts.Param.token, (Object)token);
        if (!SaFoxUtil.isEmpty((Object)state)) {
            this.checkState(state);
            url = SaFoxUtil.joinSharpParam((String)url, (String)SaOAuth2Consts.Param.state, (Object)state);
        }
        return url;
    }

    @Override
    public void checkState(String state) {
        String value = SaOAuth2Manager.getDao().getState(state);
        if (SaFoxUtil.isNotEmpty((Object)value)) {
            throw new SaOAuth2Exception("\u591a\u6b21\u8bf7\u6c42\u7684 state \u4e0d\u53ef\u91cd\u590d: " + state).setCode(30127);
        }
        SaOAuth2Manager.getDao().saveState(state);
    }
}

