/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.oauth2.granttype.handler;

import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.oauth2.SaOAuth2Manager;
import cn.dev33.satoken.oauth2.consts.GrantType;
import cn.dev33.satoken.oauth2.consts.SaOAuth2Consts;
import cn.dev33.satoken.oauth2.data.model.AccessTokenModel;
import cn.dev33.satoken.oauth2.data.model.request.RequestAuthModel;
import cn.dev33.satoken.oauth2.exception.SaOAuth2Exception;
import cn.dev33.satoken.oauth2.granttype.handler.SaOAuth2GrantTypeHandlerInterface;
import cn.dev33.satoken.oauth2.granttype.handler.model.PasswordAuthResult;
import cn.dev33.satoken.oauth2.strategy.SaOAuth2Strategy;
import cn.dev33.satoken.stp.StpUtil;
import java.util.List;

public class PasswordGrantTypeHandler
implements SaOAuth2GrantTypeHandlerInterface {
    @Override
    public String getHandlerGrantType() {
        return GrantType.password;
    }

    @Override
    public AccessTokenModel getAccessToken(SaRequest req, String clientId, List<String> scopes) {
        String password;
        String username = req.getParamNotNull(SaOAuth2Consts.Param.username);
        PasswordAuthResult passwordAuthResult = this.loginByUsernamePassword(username, password = req.getParamNotNull(SaOAuth2Consts.Param.password));
        Object loginId = passwordAuthResult.getLoginId();
        if (loginId == null) {
            throw new SaOAuth2Exception("\u767b\u5f55\u5931\u8d25").setCode(30161);
        }
        RequestAuthModel ra = new RequestAuthModel();
        ra.clientId = clientId;
        ra.loginId = loginId;
        ra.scopes = scopes;
        AccessTokenModel at = SaOAuth2Manager.getDataGenerate().generateAccessToken(ra, true, atm -> {
            atm.grantType = GrantType.password;
        });
        return at;
    }

    public PasswordAuthResult loginByUsernamePassword(String username, String password) {
        System.err.println("\u8b66\u544a\u4fe1\u606f\uff1a\u5f53\u524d password \u8ba4\u8bc1\u6a21\u5f0f\uff0c\u4f7f\u7528\u9ed8\u8ba4\u5b9e\u73b0 (SaOAuth2Strategy.instance.doLoginHandle)\uff0c\u4ec5\u4f9b\u5f00\u53d1\u6d4b\u8bd5");
        System.err.println("\u6b63\u5f0f\u9879\u76ee\u8bf7\u91cd\u5199 PasswordGrantTypeHandler \u5904\u7406\u5668 loginByUsernamePassword \u65b9\u6cd5");
        SaOAuth2Strategy.instance.doLoginHandle.apply(username, password);
        Object loginId = StpUtil.getLoginIdDefaultNull();
        return new PasswordAuthResult(loginId);
    }
}

