/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.oauth2.template;

import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.oauth2.SaOAuth2Manager;
import cn.dev33.satoken.oauth2.dao.SaOAuth2Dao;
import cn.dev33.satoken.oauth2.data.model.AccessTokenModel;
import cn.dev33.satoken.oauth2.data.model.ClientTokenModel;
import cn.dev33.satoken.oauth2.data.model.CodeModel;
import cn.dev33.satoken.oauth2.data.model.RefreshTokenModel;
import cn.dev33.satoken.oauth2.data.model.loader.SaClientModel;
import cn.dev33.satoken.oauth2.exception.SaOAuth2AccessTokenException;
import cn.dev33.satoken.oauth2.exception.SaOAuth2AccessTokenScopeException;
import cn.dev33.satoken.oauth2.exception.SaOAuth2AuthorizationCodeException;
import cn.dev33.satoken.oauth2.exception.SaOAuth2ClientModelException;
import cn.dev33.satoken.oauth2.exception.SaOAuth2ClientModelScopeException;
import cn.dev33.satoken.oauth2.exception.SaOAuth2ClientTokenException;
import cn.dev33.satoken.oauth2.exception.SaOAuth2ClientTokenScopeException;
import cn.dev33.satoken.oauth2.exception.SaOAuth2Exception;
import cn.dev33.satoken.oauth2.exception.SaOAuth2RefreshTokenException;
import cn.dev33.satoken.strategy.SaStrategy;
import cn.dev33.satoken.util.SaFoxUtil;
import java.util.List;

public class SaOAuth2Template {
    public SaClientModel getClientModel(String clientId) {
        return SaOAuth2Manager.getDataLoader().getClientModel(clientId);
    }

    public SaClientModel checkClientModel(String clientId) {
        SaClientModel clientModel = this.getClientModel(clientId);
        if (clientModel == null) {
            throw new SaOAuth2ClientModelException("\u65e0\u6548 client_id: " + clientId).setClientId(clientId).setCode(30105);
        }
        return clientModel;
    }

    public SaClientModel checkClientSecret(String clientId, String clientSecret) {
        SaClientModel cm = this.checkClientModel(clientId);
        if (cm.clientSecret == null || !cm.clientSecret.equals(clientSecret)) {
            throw new SaOAuth2ClientModelException("\u65e0\u6548 client_secret: " + clientSecret).setClientId(clientId).setCode(30115);
        }
        return cm;
    }

    public SaClientModel checkClientSecretAndScope(String clientId, String clientSecret, List<String> scopes) {
        SaClientModel cm = this.checkClientSecret(clientId, clientSecret);
        this.checkContractScope(cm, scopes);
        return cm;
    }

    public boolean isContractScope(String clientId, List<String> scopes) {
        try {
            this.checkContractScope(clientId, scopes);
            return true;
        }
        catch (SaOAuth2ClientModelException e) {
            return false;
        }
    }

    public SaClientModel checkContractScope(String clientId, List<String> scopes) {
        return this.checkContractScope(this.checkClientModel(clientId), scopes);
    }

    public SaClientModel checkContractScope(SaClientModel cm, List<String> scopes) {
        if (SaFoxUtil.isEmptyList(scopes)) {
            return cm;
        }
        for (String scope : scopes) {
            if (cm.contractScopes.contains(scope)) continue;
            throw new SaOAuth2ClientModelScopeException("\u8be5 client \u6682\u672a\u7b7e\u7ea6 scope: " + scope).setClientId(cm.clientId).setScope(scope).setCode(30112);
        }
        return cm;
    }

    public void checkRedirectUri(String clientId, String url) {
        if (!SaFoxUtil.isUrl((String)url)) {
            throw new SaOAuth2ClientModelException("\u65e0\u6548 redirect_url\uff1a" + url).setClientId(clientId).setCode(30113);
        }
        int qIndex = url.indexOf("?");
        if (qIndex != -1) {
            url = url.substring(0, qIndex);
        }
        if (url.contains("@")) {
            throw new SaOAuth2ClientModelException("\u65e0\u6548 redirect_url\uff08\u4e0d\u5141\u8bb8\u51fa\u73b0@\u5b57\u7b26\uff09\uff1a" + url).setClientId(clientId).setCode(30113);
        }
        SaClientModel clientModel = this.checkClientModel(clientId);
        this.checkRedirectUriListNormal(clientModel.allowRedirectUris);
        if (!((Boolean)SaStrategy.instance.hasElement.apply(clientModel.allowRedirectUris, (Object)url)).booleanValue()) {
            throw new SaOAuth2ClientModelException("\u975e\u6cd5 redirect_url: " + url).setClientId(clientId).setCode(30114);
        }
    }

    public void checkRedirectUriListNormal(List<String> redirectUriList) {
        SaOAuth2Template.checkRedirectUriListNormalStaticMethod(redirectUriList);
    }

    public static void checkRedirectUriListNormalStaticMethod(List<String> redirectUriList) {
        for (String url : redirectUriList) {
            int index = url.indexOf("*");
            if (index == -1 || index == url.length() - 1) continue;
            throw new SaOAuth2Exception("\u65e0\u6548\u7684 allow-url \u914d\u7f6e\uff08*\u901a\u914d\u7b26\u53ea\u5141\u8bb8\u51fa\u73b0\u5728\u6700\u540e\u4e00\u4f4d\uff09\uff1a" + url).setCode(30114);
        }
    }

    public boolean isGrantScope(Object loginId, String clientId, List<String> scopes) {
        List<String> grantScopeList = SaOAuth2Manager.getDao().getGrantScope(clientId, loginId);
        return SaFoxUtil.list1ContainList2AllElement(grantScopeList, scopes);
    }

    public boolean isNeedCarefulConfirm(Object loginId, String clientId, List<String> scopes) {
        if (scopes == null || scopes.isEmpty()) {
            return false;
        }
        List<String> higherScopeList = this.getHigherScopeList();
        if (SaFoxUtil.list1ContainList2AnyElement(scopes, higherScopeList)) {
            return true;
        }
        List<String> lowerScopeList = this.getLowerScopeList();
        if ((scopes = SaFoxUtil.list1RemoveByList2(scopes, lowerScopeList)).isEmpty()) {
            return false;
        }
        return !this.isGrantScope(loginId, clientId, scopes);
    }

    public void deleteGrantScope(Object loginId, String clientId) {
        SaOAuth2Manager.getDao().deleteGrantScope(clientId, loginId);
    }

    public CodeModel checkGainTokenParam(String code, String clientId, String clientSecret, String redirectUri) {
        SaOAuth2Dao dao = SaOAuth2Manager.getDao();
        CodeModel cm = dao.getCode(code);
        SaOAuth2AuthorizationCodeException.throwBy(cm == null, "\u65e0\u6548 code: " + code, code, 30110);
        SaOAuth2ClientModelException.throwBy(!cm.clientId.equals(clientId), "\u65e0\u6548 client_id: " + clientId, clientId, 30105);
        String dbSecret = this.checkClientModel((String)clientId).clientSecret;
        SaOAuth2ClientModelException.throwBy(dbSecret == null || !dbSecret.equals(clientSecret), "\u65e0\u6548 client_secret: " + clientSecret, clientId, 30115);
        if (!SaFoxUtil.isEmpty((Object)redirectUri)) {
            SaOAuth2ClientModelException.throwBy(!redirectUri.equals(cm.redirectUri), "\u65e0\u6548 redirect_uri: " + redirectUri, clientId, 30120);
        }
        return cm;
    }

    public RefreshTokenModel checkRefreshTokenParam(String clientId, String clientSecret, String refreshToken) {
        SaOAuth2Dao dao = SaOAuth2Manager.getDao();
        RefreshTokenModel rt = dao.getRefreshToken(refreshToken);
        SaOAuth2RefreshTokenException.throwBy(rt == null, "\u65e0\u6548 refresh_token: " + refreshToken, refreshToken, 30111);
        SaOAuth2ClientModelException.throwBy(!rt.clientId.equals(clientId), "\u65e0\u6548 client_id: " + clientId, clientId, 30122);
        String dbSecret = this.checkClientModel((String)clientId).clientSecret;
        SaOAuth2ClientModelException.throwBy(dbSecret == null || !dbSecret.equals(clientSecret), "\u65e0\u6548 client_secret: " + clientSecret, clientId, 30115);
        return rt;
    }

    public AccessTokenModel checkAccessTokenParam(String clientId, String clientSecret, String accessToken) {
        AccessTokenModel at = this.checkAccessToken(accessToken);
        SaOAuth2ClientModelException.throwBy(!at.clientId.equals(clientId), "\u65e0\u6548 client_id\uff1a" + clientId, clientId, 30122);
        this.checkClientSecret(clientId, clientSecret);
        return at;
    }

    public CodeModel getCode(String code) {
        return SaOAuth2Manager.getDao().getCode(code);
    }

    public CodeModel checkCode(String code) {
        CodeModel cm = SaOAuth2Manager.getDao().getCode(code);
        if (cm == null) {
            throw new SaOAuth2AuthorizationCodeException("\u65e0\u6548 code: " + code).setAuthorizationCode(code).setCode(30110);
        }
        return cm;
    }

    public String getCodeValue(String clientId, Object loginId) {
        return SaOAuth2Manager.getDao().getCodeValue(clientId, loginId);
    }

    public AccessTokenModel getAccessToken(String accessToken) {
        return SaOAuth2Manager.getDao().getAccessToken(accessToken);
    }

    public AccessTokenModel checkAccessToken(String accessToken) {
        AccessTokenModel at = SaOAuth2Manager.getDao().getAccessToken(accessToken);
        if (at == null) {
            throw new SaOAuth2AccessTokenException("\u65e0\u6548 access_token: " + accessToken).setAccessToken(accessToken).setCode(30106);
        }
        return at;
    }

    public List<String> getAccessTokenValueList(String clientId, Object loginId) {
        return SaOAuth2Manager.getDao().getAccessTokenValueList_FromAdjustAfter(clientId, loginId);
    }

    public boolean hasAccessTokenScope(String accessToken, String ... scopes) {
        try {
            this.checkAccessTokenScope(accessToken, scopes);
            return true;
        }
        catch (SaOAuth2AccessTokenException e) {
            return false;
        }
    }

    public void checkAccessTokenScope(String accessToken, String ... scopes) {
        AccessTokenModel at = this.checkAccessToken(accessToken);
        if (SaFoxUtil.isEmptyArray((Object[])scopes)) {
            return;
        }
        for (String scope : scopes) {
            if (at.scopes.contains(scope)) continue;
            throw new SaOAuth2AccessTokenScopeException("\u8be5 access_token \u4e0d\u5177\u5907 scope\uff1a" + scope).setAccessToken(accessToken).setScope(scope).setCode(30108);
        }
    }

    public Object getLoginIdByAccessToken(String accessToken) {
        return this.checkAccessToken((String)accessToken).loginId;
    }

    public Object getClientIdByAccessToken(String accessToken) {
        return this.checkAccessToken((String)accessToken).clientId;
    }

    public void revokeAccessToken(String accessToken) {
        AccessTokenModel at = this.getAccessToken(accessToken);
        if (at == null) {
            return;
        }
        SaOAuth2Dao dao = SaOAuth2Manager.getDao();
        dao.deleteAccessToken(accessToken);
        dao.deleteAccessTokenIndex_BySingleData(at.clientId, at.loginId, accessToken);
    }

    public void revokeAccessTokenByIndex(String clientId, Object loginId) {
        SaOAuth2Dao dao = SaOAuth2Manager.getDao();
        List<String> accessTokenList = this.getAccessTokenValueList(clientId, loginId);
        if (!accessTokenList.isEmpty()) {
            for (String accessToken : accessTokenList) {
                dao.deleteAccessToken(accessToken);
            }
            dao.deleteAccessTokenIndex(clientId, loginId);
        }
    }

    public RefreshTokenModel getRefreshToken(String refreshToken) {
        return SaOAuth2Manager.getDao().getRefreshToken(refreshToken);
    }

    public RefreshTokenModel checkRefreshToken(String refreshToken) {
        RefreshTokenModel rt = SaOAuth2Manager.getDao().getRefreshToken(refreshToken);
        if (rt == null) {
            throw new SaOAuth2RefreshTokenException("\u65e0\u6548 refresh_token: " + refreshToken).setRefreshToken(refreshToken).setCode(30111);
        }
        return rt;
    }

    public List<String> getRefreshTokenValueList(String clientId, Object loginId) {
        return SaOAuth2Manager.getDao().getRefreshTokenValueList_FromAdjustAfter(clientId, loginId);
    }

    public void revokeRefreshToken(String refreshToken) {
        RefreshTokenModel rt = this.getRefreshToken(refreshToken);
        if (rt == null) {
            return;
        }
        SaOAuth2Dao dao = SaOAuth2Manager.getDao();
        dao.deleteRefreshToken(refreshToken);
        dao.deleteRefreshTokenIndex_BySingleData(rt.clientId, rt.loginId, refreshToken);
    }

    public void revokeRefreshTokenByIndex(String clientId, Object loginId) {
        SaOAuth2Dao dao = SaOAuth2Manager.getDao();
        List<String> refreshTokenList = this.getRefreshTokenValueList(clientId, loginId);
        if (!refreshTokenList.isEmpty()) {
            for (String refreshToken : refreshTokenList) {
                dao.deleteRefreshToken(refreshToken);
            }
            dao.deleteRefreshTokenIndex(clientId, loginId);
        }
    }

    public AccessTokenModel refreshAccessToken(String refreshToken) {
        return SaOAuth2Manager.getDataGenerate().refreshAccessToken(refreshToken);
    }

    public ClientTokenModel getClientToken(String clientToken) {
        return SaOAuth2Manager.getDao().getClientToken(clientToken);
    }

    public ClientTokenModel checkClientToken(String clientToken) {
        ClientTokenModel ct = this.getClientToken(clientToken);
        if (ct == null) {
            throw new SaOAuth2ClientTokenException("\u65e0\u6548 client_token: " + clientToken).setClientToken(clientToken).setCode(30107);
        }
        return ct;
    }

    public List<String> getClientTokenValueList(String clientId) {
        return SaOAuth2Manager.getDao().getClientTokenValueList_FromAdjustAfter(clientId);
    }

    public boolean hasClientTokenScope(String clientToken, String ... scopes) {
        try {
            this.checkClientTokenScope(clientToken, scopes);
            return true;
        }
        catch (SaOAuth2ClientTokenException e) {
            return false;
        }
    }

    public void checkClientTokenScope(String clientToken, String ... scopes) {
        ClientTokenModel ct = this.checkClientToken(clientToken);
        if (SaFoxUtil.isEmptyArray((Object[])scopes)) {
            return;
        }
        for (String scope : scopes) {
            if (ct.scopes.contains(scope)) continue;
            throw new SaOAuth2ClientTokenScopeException("\u8be5 client_token \u4e0d\u5177\u5907 scope\uff1a" + scope).setClientToken(clientToken).setScope(scope).setCode(30109);
        }
    }

    public void revokeClientToken(String clientToken) {
        ClientTokenModel ct = this.getClientToken(clientToken);
        if (ct == null) {
            return;
        }
        SaOAuth2Dao dao = SaOAuth2Manager.getDao();
        dao.deleteClientToken(clientToken);
        dao.deleteClientTokenIndex_BySingleData(ct.clientId, clientToken);
    }

    public void revokeClientTokenByIndex(String clientId) {
        SaOAuth2Dao dao = SaOAuth2Manager.getDao();
        List<String> clientTokenList = this.getClientTokenValueList(clientId);
        if (!clientTokenList.isEmpty()) {
            for (String clientToken : clientTokenList) {
                dao.deleteClientToken(clientToken);
            }
            dao.deleteClientTokenIndex(clientId);
        }
    }

    public AccessTokenModel currentAccessToken() {
        String accessToken = SaOAuth2Manager.getDataResolver().readAccessToken(SaHolder.getRequest());
        return this.checkAccessToken(accessToken);
    }

    public ClientTokenModel currentClientToken() {
        String clientToken = SaOAuth2Manager.getDataResolver().readClientToken(SaHolder.getRequest());
        return this.checkClientToken(clientToken);
    }

    public void saveGrantScope(String clientId, Object loginId, List<String> scopes) {
        SaOAuth2Manager.getDao().saveGrantScope(clientId, loginId, scopes);
    }

    public List<String> getHigherScopeList() {
        return SaOAuth2Manager.getDataLoader().getHigherScopeList();
    }

    public List<String> getLowerScopeList() {
        return SaOAuth2Manager.getDataLoader().getLowerScopeList();
    }
}

