/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.filter;

import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.filter.SaFilterAuthStrategy;
import cn.dev33.satoken.filter.SaFilterErrorStrategy;
import cn.dev33.satoken.router.SaRouterUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.springframework.core.annotation.Order;

@Order(value=-100)
public class SaServletFilter
implements Filter {
    private List<String> includeList = new ArrayList<String>();
    private List<String> excludeList = new ArrayList<String>();
    public SaFilterAuthStrategy auth = r -> {};
    public SaFilterErrorStrategy error = e -> {
        throw new SaTokenException(e);
    };
    public SaFilterAuthStrategy beforeAuth = r -> {};

    public SaServletFilter addInclude(String ... paths) {
        this.includeList.addAll(Arrays.asList(paths));
        return this;
    }

    public SaServletFilter addExclude(String ... paths) {
        this.excludeList.addAll(Arrays.asList(paths));
        return this;
    }

    public SaServletFilter setIncludeList(List<String> pathList) {
        this.includeList = pathList;
        return this;
    }

    public SaServletFilter setExcludeList(List<String> pathList) {
        this.excludeList = pathList;
        return this;
    }

    public List<String> getIncludeList() {
        return this.includeList;
    }

    public List<String> getExcludeList() {
        return this.excludeList;
    }

    public SaServletFilter setAuth(SaFilterAuthStrategy auth) {
        this.auth = auth;
        return this;
    }

    public SaServletFilter setError(SaFilterErrorStrategy error) {
        this.error = error;
        return this;
    }

    public SaServletFilter setBeforeAuth(SaFilterAuthStrategy beforeAuth) {
        this.beforeAuth = beforeAuth;
        return this;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            SaRouterUtil.match(this.includeList, this.excludeList, () -> {
                this.beforeAuth.run(null);
                this.auth.run(null);
            });
        }
        catch (Throwable e) {
            Object result = this.error.run(e);
            String resultString = String.valueOf(result);
            response.setContentType("text/plain; charset=utf-8");
            response.getWriter().print(resultString);
            return;
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

