/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.sso.message;

import cn.dev33.satoken.sso.exception.SaSsoException;
import cn.dev33.satoken.sso.function.SaSsoMessageHandleFunction;
import cn.dev33.satoken.sso.message.SaSsoMessage;
import cn.dev33.satoken.sso.message.handle.SaSsoMessageHandle;
import cn.dev33.satoken.sso.message.handle.SaSsoMessageSimpleHandle;
import cn.dev33.satoken.sso.template.SaSsoTemplate;
import java.util.LinkedHashMap;
import java.util.Map;

public class SaSsoMessageHolder {
    public final Map<String, SaSsoMessageHandle> messageHandleMap = new LinkedHashMap<String, SaSsoMessageHandle>();

    public boolean hasHandle(String type) {
        return this.messageHandleMap.containsKey(type);
    }

    public SaSsoMessageHolder removeHandle(String type) {
        this.messageHandleMap.remove(type);
        return this;
    }

    public SaSsoMessageHolder addHandle(SaSsoMessageHandle handle) {
        this.messageHandleMap.put(handle.getHandlerType(), handle);
        return this;
    }

    public SaSsoMessageHolder addHandle(String type, SaSsoMessageHandleFunction handle) {
        this.messageHandleMap.put(type, new SaSsoMessageSimpleHandle(type, handle));
        return this;
    }

    public SaSsoMessageHandle getHandle(String type) {
        return this.messageHandleMap.get(type);
    }

    public Object handleMessage(SaSsoTemplate ssoTemplate, SaSsoMessage message) {
        SaSsoMessageHandle handle = this.messageHandleMap.get(message.getType());
        if (handle == null) {
            throw new SaSsoException("\u672a\u80fd\u627e\u5230\u6d88\u606f\u5904\u7406\u5668: " + message.getType()).setCode(30021);
        }
        return handle.handle(ssoTemplate, message);
    }
}

