/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie;

import cn.dreampie.reflect.Reflect;
import com.google.common.collect.Lists;
import com.jfinal.log.Logger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassSearchKit {
    protected static final Logger LOG = Logger.getLogger(ClassSearchKit.class);
    private List<String> includepaths = Lists.newArrayList();
    private Class target;

    private static <T> List<Class<? extends T>> extraction(Class<T> clazz, List<String> classFileList) {
        ArrayList classList = Lists.newArrayList();
        for (String classFile : classFileList) {
            Class classInFile = (Class)Reflect.on(classFile).get();
            if (!clazz.isAssignableFrom(classInFile) || clazz == classInFile) continue;
            classList.add(classInFile);
        }
        return classList;
    }

    public static ClassSearchKit of(Class target) {
        return new ClassSearchKit(target);
    }

    private static List<String> findFiles(String baseDirName, String targetFileName) {
        List<Object> classFiles = Lists.newArrayList();
        Enumeration<URL> baseURLs = null;
        try {
            baseURLs = ClassSearchKit.class.getClassLoader().getResources(File.separator + baseDirName.replaceAll("\\.", "/"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        URL baseURL = null;
        while (baseURLs.hasMoreElements()) {
            baseURL = (URL)baseURLs.nextElement();
            if (baseURL == null) continue;
            String protocol = baseURL.getProtocol();
            String basePath = baseURL.getFile();
            if ("jar".equals(protocol)) {
                String[] paths = basePath.split("!/");
                try {
                    classFiles = ClassSearchKit.findJarFile(URLDecoder.decode(paths[0].replace("file:", ""), "UTF-8"), paths[1]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            classFiles = ClassSearchKit.findPathFiles(basePath, targetFileName);
        }
        return classFiles;
    }

    private static List<String> findPathFiles(String baseDirName, String targetFileName) {
        ArrayList classFiles = Lists.newArrayList();
        String tempName = null;
        File baseDir = new File(baseDirName);
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            LOG.error("search error\uff1a" + baseDirName + "is not a dir\uff01");
        } else {
            String[] filelist = baseDir.list();
            String classname = null;
            String tem = null;
            for (int i = 0; i < filelist.length; ++i) {
                File readfile = new File(baseDirName + File.separator + filelist[i]);
                if (readfile.isDirectory()) {
                    classFiles.addAll(ClassSearchKit.findPathFiles(baseDirName + File.separator + filelist[i], targetFileName));
                    continue;
                }
                tempName = readfile.getName();
                if (!ClassSearchKit.wildcardMatch(targetFileName, tempName)) continue;
                tem = readfile.getAbsoluteFile().toString().replaceAll("\\\\", "/");
                classname = tem.substring(tem.indexOf("classes/") + "classes/".length(), tem.indexOf(".class"));
                classFiles.add(classname.replaceAll("/", "."));
            }
        }
        return classFiles;
    }

    private static boolean wildcardMatch(String pattern, String str) {
        int patternLength = pattern.length();
        int strLength = str.length();
        int strIndex = 0;
        for (int patternIndex = 0; patternIndex < patternLength; ++patternIndex) {
            char ch = pattern.charAt(patternIndex);
            if (ch == '*') {
                while (strIndex < strLength) {
                    if (ClassSearchKit.wildcardMatch(pattern.substring(patternIndex + 1), str.substring(strIndex))) {
                        return true;
                    }
                    ++strIndex;
                }
                continue;
            }
            if (ch == '?') {
                if (++strIndex <= strLength) continue;
                return false;
            }
            if (strIndex >= strLength || ch != str.charAt(strIndex)) {
                return false;
            }
            ++strIndex;
        }
        return strIndex == strLength;
    }

    public ClassSearchKit(Class target) {
        this.target = target;
    }

    public ClassSearchKit includepaths(String ... classpaths) {
        if (classpaths != null) {
            for (String classpath : classpaths) {
                this.includepaths.add(classpath);
            }
        }
        return this;
    }

    public ClassSearchKit includepaths(List<String> classpaths) {
        if (classpaths != null) {
            for (String classpath : classpaths) {
                this.includepaths.add(classpath);
            }
        }
        return this;
    }

    public <T> List<Class<? extends T>> search() {
        if (this.includepaths.size() <= 0) {
            ArrayList classFileList = Lists.newArrayList();
            Enumeration<URL> resources = null;
            try {
                resources = ClassSearchKit.class.getClassLoader().getResources("");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            URL resource = null;
            while (resources.hasMoreElements()) {
                resource = resources.nextElement();
                classFileList.addAll(ClassSearchKit.findPathFiles(resource.getPath(), "*.class"));
            }
            return ClassSearchKit.extraction(this.target, classFileList);
        }
        ArrayList classFileList = Lists.newArrayList();
        for (String classpath : this.includepaths) {
            classFileList.addAll(ClassSearchKit.findFiles(classpath, "*.class"));
        }
        return ClassSearchKit.extraction(this.target, classFileList);
    }

    private List<String> findjarFiles(String baseDirName, final List<String> includeJars, String packageName) {
        ArrayList classFiles = Lists.newArrayList();
        try {
            File baseDir = new File(baseDirName);
            if (!baseDir.exists() || !baseDir.isDirectory()) {
                LOG.error("file serach error\uff1a" + baseDirName + " is not a dir\uff01");
            } else {
                String[] filelist = baseDir.list(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return includeJars.contains(name);
                    }
                });
                for (int i = 0; i < filelist.length; ++i) {
                    classFiles.addAll(ClassSearchKit.findJarFile(baseDirName + File.separator + filelist[i], packageName));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classFiles;
    }

    private static List<String> findJarFile(String filePath, String packageName) throws IOException {
        List<Object> classFiles = Lists.newArrayList();
        JarFile localJarFile = new JarFile(new File(filePath));
        classFiles = ClassSearchKit.findInJar(localJarFile, packageName);
        localJarFile.close();
        return classFiles;
    }

    private static List<String> findInJar(JarFile localJarFile, String packageName) {
        ArrayList classFiles = Lists.newArrayList();
        Enumeration<JarEntry> entries = localJarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            String entryName = jarEntry.getName();
            if (jarEntry.isDirectory() || packageName != null && !entryName.startsWith(packageName) || !entryName.endsWith(".class")) continue;
            String className = entryName.replaceAll("/", ".").substring(0, entryName.length() - 6);
            classFiles.add(className);
        }
        return classFiles;
    }
}

