/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.callbacks;

import cn.felord.WeComException;
import cn.felord.callbacks.ByteCollector;
import cn.felord.callbacks.CallbackAsyncConsumer;
import cn.felord.callbacks.CallbackSettings;
import cn.felord.callbacks.CallbackSettingsService;
import cn.felord.callbacks.CallbackXmlBody;
import cn.felord.callbacks.CallbackXmlResponse;
import cn.felord.callbacks.PKCS7Encoder;
import cn.felord.domain.callback.CallbackEventBody;
import cn.felord.domain.callback.CallbackResource;
import cn.felord.domain.corpay.miniapppay.callback.RefundCallbackData;
import cn.felord.domain.corpay.miniapppay.callback.TransactionCallbackData;
import cn.felord.enumeration.CallbackEvent;
import cn.felord.enumeration.PayCallbackEventType;
import cn.felord.json.JacksonObjectMapperFactory;
import cn.felord.utils.Algorithms;
import cn.felord.utils.Base64Utils;
import cn.felord.utils.StringUtils;
import cn.felord.xml.XmlReader;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CallbackCrypto {
    private static final String BOM = "\ufeff";
    private static final String BASE_ = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private static final String MSG = "{\"encrypt\":\"%1$s\",\"msgsignature\":\"%2$s\",\"timestamp\":\"%3$s\",\"nonce\":\"%4$s\"}";
    private static final Random RANDOM = new SecureRandom();
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.create();
    private final XmlReader xmlReader;
    private final CallbackAsyncConsumer callbackAsyncConsumer;
    private final CallbackSettingsService callbackSettingsService;

    CallbackCrypto(XmlReader xmlReader, CallbackSettingsService callbackSettingsService, CallbackAsyncConsumer callbackAsyncConsumer) {
        this.xmlReader = xmlReader;
        this.callbackSettingsService = callbackSettingsService;
        this.callbackAsyncConsumer = callbackAsyncConsumer;
    }

    byte[] getNetworkBytesOrder(int sourceNumber) {
        byte[] orderBytes = new byte[4];
        orderBytes[3] = (byte)(sourceNumber & 0xFF);
        orderBytes[2] = (byte)(sourceNumber >> 8 & 0xFF);
        orderBytes[1] = (byte)(sourceNumber >> 16 & 0xFF);
        orderBytes[0] = (byte)(sourceNumber >> 24 & 0xFF);
        return orderBytes;
    }

    int recoverNetworkBytesOrder(byte[] orderBytes) {
        int sourceNumber = 0;
        for (int i = 0; i < 4; ++i) {
            sourceNumber <<= 8;
            sourceNumber |= orderBytes[i] & 0xFF;
        }
        return sourceNumber;
    }

    String randomStr() {
        return RANDOM.ints(16L, 0, BASE_.length()).mapToObj(BASE_::charAt).collect(StringBuffer::new, StringBuffer::append, StringBuffer::append).toString();
    }

    String encrypt(String receiveid, byte[] aesKey, String randomStr, String text) throws WeComException {
        byte[] randomStrBytes = randomStr.getBytes(StandardCharsets.UTF_8);
        byte[] textBytes = text.getBytes(StandardCharsets.UTF_8);
        byte[] networkBytesOrder = this.getNetworkBytesOrder(textBytes.length);
        byte[] receiveidBytes = receiveid.getBytes(StandardCharsets.UTF_8);
        int byteSize = receiveidBytes.length + textBytes.length + networkBytesOrder.length + receiveidBytes.length;
        ByteCollector byteCollector = new ByteCollector().addBytes(randomStrBytes).addBytes(networkBytesOrder).addBytes(textBytes).addBytes(receiveidBytes).addBytes(PKCS7Encoder.encode(byteSize));
        byte[] unencrypted = byteCollector.toBytes();
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(aesKey, 0, 16);
            cipher.init(1, (Key)keySpec, iv);
            byte[] encrypted = cipher.doFinal(unencrypted);
            return Base64Utils.encodeToString(encrypted);
        }
        catch (Exception e) {
            throw new WeComException("error when encrypt with AES");
        }
    }

    private String decrypt(String corpId, byte[] aesKey, String text) throws WeComException {
        String fromReceiveid;
        String jsonContent;
        byte[] original;
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec spec = new SecretKeySpec(aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(Arrays.copyOfRange(aesKey, 0, 16));
            cipher.init(2, (Key)spec, iv);
            original = cipher.doFinal(Base64Utils.decodeFromString(text));
        }
        catch (Exception e) {
            throw new WeComException("error when decrypt with AES");
        }
        try {
            byte[] bytes = PKCS7Encoder.decode(original);
            byte[] networkOrder = Arrays.copyOfRange(bytes, 16, 20);
            int jsonLength = this.recoverNetworkBytesOrder(networkOrder);
            jsonContent = new String(Arrays.copyOfRange(bytes, 20, 20 + jsonLength), StandardCharsets.UTF_8);
            fromReceiveid = new String(Arrays.copyOfRange(bytes, 20 + jsonLength, bytes.length), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new WeComException("invalid buffer when callback decrypted");
        }
        if (!Objects.equals(corpId, fromReceiveid)) {
            throw new WeComException(" invalid corpid");
        }
        return jsonContent.startsWith(BOM) ? jsonContent.substring(1) : jsonContent;
    }

    public String encryptJsonMsg(String agentId, String corpId, String replyMsg, String timeStamp, String nonce) throws WeComException {
        CallbackSettings callbackSettings = this.callbackSettingsService.loadAuthentication(agentId, corpId);
        String receiveid = callbackSettings.getReceiveid();
        String encrypt = this.encrypt(receiveid, callbackSettings.getAesKey(), this.randomStr(), replyMsg);
        if (!StringUtils.hasText(timeStamp)) {
            timeStamp = Long.toString(System.currentTimeMillis());
        }
        String token = callbackSettings.getToken();
        String signature = Algorithms.sha1Signature(token, timeStamp, nonce, encrypt);
        return String.format(MSG, encrypt, signature, timeStamp, nonce);
    }

    public String encryptXmlMsg(String agentId, String corpId, String replyMsg, String timeStamp, String nonce) throws WeComException {
        CallbackSettings callbackSettings = this.callbackSettingsService.loadAuthentication(agentId, corpId);
        String receiveid = callbackSettings.getReceiveid();
        String encrypt = this.encrypt(receiveid, callbackSettings.getAesKey(), this.randomStr(), replyMsg);
        if (!StringUtils.hasText(timeStamp)) {
            timeStamp = Long.toString(Instant.now().toEpochMilli());
        }
        String token = callbackSettings.getToken();
        String signature = Algorithms.sha1Signature(token, timeStamp, nonce, encrypt);
        CallbackXmlResponse callbackXmlResponse = new CallbackXmlResponse(encrypt, signature, timeStamp, nonce);
        return this.xmlReader.write(callbackXmlResponse);
    }

    public <R> R accept(String agentId, String corpId, String msgSignature, String timeStamp, String nonce, String xmlBody, R response) {
        return this.doAccept(agentId, corpId, msgSignature, timeStamp, nonce, xmlBody, response);
    }

    public String accept(String agentId, String corpId, String msgSignature, String timeStamp, String nonce, String xmlBody) {
        return this.doAccept(agentId, corpId, msgSignature, timeStamp, nonce, xmlBody, "success");
    }

    private <T> T doAccept(String agentId, String corpId, String msgSignature, String timeStamp, String nonce, String xmlBody, T response) {
        CallbackXmlBody callbackXmlBody = this.xmlReader.read(xmlBody, CallbackXmlBody.class);
        String encrypt = callbackXmlBody.getEncrypt();
        CallbackSettings callbackSettings = this.callbackSettingsService.loadAuthentication(agentId, corpId);
        String xml = this.decryptMsg(callbackSettings, msgSignature, timeStamp, nonce, encrypt);
        CallbackEventBody eventBody = this.xmlReader.read(xml, CallbackEventBody.class);
        eventBody.setAgentId(agentId);
        eventBody.setMsgSignature(msgSignature);
        eventBody.setTimeStamp(timeStamp);
        eventBody.setNonce(nonce);
        eventBody.setEncrypt(encrypt);
        eventBody.setXmlAgentId(callbackXmlBody.getAgentId());
        eventBody.setOriginalXml(xml);
        if (Objects.nonNull(eventBody.getResource())) {
            this.payCallback(eventBody, callbackSettings);
        }
        this.callbackAsyncConsumer.asyncAction(eventBody);
        return response;
    }

    private void payCallback(CallbackEventBody eventBody, CallbackSettings callbackSettings) {
        CallbackResource resource = eventBody.getResource();
        String associatedData = resource.getAssociatedData();
        String nonce = resource.getNonce();
        String ciphertext = resource.getCiphertext();
        String json = Algorithms.aesDecode(callbackSettings.getAesKey(), associatedData, nonce, ciphertext);
        PayCallbackEventType eventType = eventBody.getEventType();
        if (Objects.equals((Object)eventType, (Object)PayCallbackEventType.TRANSACTION_SUCCESS)) {
            try {
                TransactionCallbackData transactionCallbackData = (TransactionCallbackData)MAPPER.readValue(json, TransactionCallbackData.class);
                eventBody.setTransactionCallbackData(transactionCallbackData);
            }
            catch (JsonProcessingException e) {
                throw new WeComException("pay transaction callback error on json conversion", e);
            }
        }
        if (Objects.equals((Object)eventType, (Object)PayCallbackEventType.REFUND_CLOSED) || Objects.equals((Object)eventType, (Object)PayCallbackEventType.REFUND_ABNORMAL) || Objects.equals((Object)eventType, (Object)PayCallbackEventType.REFUND_SUCCESS)) {
            eventBody.setEvent(CallbackEvent.PAY_REFUND);
            try {
                RefundCallbackData refundCallbackData = (RefundCallbackData)MAPPER.readValue(json, RefundCallbackData.class);
                eventBody.setRefundCallbackData(refundCallbackData);
            }
            catch (JsonProcessingException e) {
                throw new WeComException("pay refund callback error on json conversion", e);
            }
        }
        eventBody.setMsgType("event");
    }

    public String decryptMsg(String agentId, String corpId, String msgSignature, String timeStamp, String nonce, String encrypt) {
        CallbackSettings callbackSettings = this.callbackSettingsService.loadAuthentication(agentId, corpId);
        return this.decryptMsg(callbackSettings, msgSignature, timeStamp, nonce, encrypt);
    }

    public String decryptMsg(CallbackSettings callbackSettings, String msgSignature, String timeStamp, String nonce, String encrypt) {
        String token = callbackSettings.getToken();
        String signature = Algorithms.sha1Signature(token, timeStamp, nonce, encrypt);
        if (!Objects.equals(msgSignature, signature)) {
            throw new WeComException("callback signature not matched");
        }
        byte[] aesKey = callbackSettings.getAesKey();
        return this.decrypt(callbackSettings.getReceiveid(), aesKey, encrypt);
    }
}

