/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.approval;

import cn.felord.domain.approval.ApplyContentData;
import cn.felord.domain.approval.ApplyData;
import cn.felord.domain.approval.ApprovalContentData;
import cn.felord.domain.approval.Approver;
import cn.felord.domain.approval.ContentDataValue;
import cn.felord.domain.approval.ListContentDataValue;
import cn.felord.domain.approval.Summary;
import cn.felord.domain.approval.TableConfig;
import cn.felord.domain.approval.TableCtrlProperty;
import cn.felord.domain.approval.TableValue;
import cn.felord.domain.approval.TmpControl;
import cn.felord.enumeration.ApprovalNotifyType;
import cn.felord.enumeration.UseTemplateApprover;
import cn.felord.utils.CollectionUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ApprovalApplyRequest {
    private final String creatorUserid;
    private final String templateId;
    private final UseTemplateApprover useTemplateApprover;
    private Long chooseDepartment;
    private List<Approver> approver;
    private List<String> notifyer;
    private ApprovalNotifyType notifyType;
    private final ApplyData<ApprovalContentData<? extends ContentDataValue>> applyData;
    private final List<Summary> summaryList;

    public static ApprovalApplyRequest approverMode(String creatorUserid, String templateId, List<Approver> approver, ApplyData<ApprovalContentData<? extends ContentDataValue>> applyData, List<Summary> summaryList) {
        return ApprovalApplyRequest.approverMode(creatorUserid, templateId, approver, Collections.emptyList(), null, applyData, summaryList);
    }

    public static ApprovalApplyRequest approverMode(String creatorUserid, String templateId, List<Approver> approver, List<String> notifyer, ApprovalNotifyType notifyType, ApplyData<ApprovalContentData<? extends ContentDataValue>> applyData, List<Summary> summaryList) {
        return new ApprovalApplyRequest(creatorUserid, templateId, applyData, summaryList, UseTemplateApprover.APPROVER_MODE).approver(approver).notifyer(notifyer).notifyType(notifyType);
    }

    public static ApprovalApplyRequest backendMode(String creatorUserid, String templateId, ApplyData<ApprovalContentData<? extends ContentDataValue>> applyData, List<Summary> summaryList) {
        return new ApprovalApplyRequest(creatorUserid, templateId, applyData, summaryList, UseTemplateApprover.BACKEND_MODE);
    }

    public static ApplyData<ApprovalContentData<? extends ContentDataValue>> applyData(List<? extends TmpControl<?>> controls, List<? extends ContentDataValue> dataValues) {
        int valueSize;
        int ctrlSize = controls.size();
        if (ctrlSize != (valueSize = dataValues.size())) {
            throw new IllegalArgumentException("ctrl size and table value size do not match");
        }
        List contents = IntStream.range(0, ctrlSize).mapToObj(index -> ApprovalApplyRequest.toDataValue((TmpControl)controls.get(index), (ContentDataValue)dataValues.get(index))).collect(Collectors.toList());
        return new ApplyData<ApprovalContentData<? extends ContentDataValue>>(contents);
    }

    private static ApprovalContentData<ContentDataValue> toDataValue(TmpControl<?> tmpControl, ContentDataValue dataValue) {
        ContentDataValue v;
        Object config = tmpControl.getConfig();
        if (config != null && config.getClass().isAssignableFrom(TableConfig.class)) {
            ListContentDataValue internalValue = (ListContentDataValue)dataValue;
            if (internalValue == null) {
                throw new IllegalArgumentException("approval internalValue must not be null");
            }
            List<? extends ContentDataValue> tableValues = internalValue.getValues();
            if (CollectionUtils.isEmpty(tableValues)) {
                throw new IllegalArgumentException("approval table values must not be empty");
            }
            TableConfig tableConfig = (TableConfig)config;
            List<TableCtrlProperty> children = tableConfig.getTable().getChildren();
            int ctrlSize = children.size();
            if (ctrlSize != tableValues.size()) {
                throw new IllegalArgumentException("ctrl size and table value size do not match");
            }
            List<ApplyContentData<?>> applyContentData = IntStream.range(0, ctrlSize).mapToObj(index -> ApplyContentData.from(((TableCtrlProperty)children.get(index)).getProperty(), (ContentDataValue)tableValues.get(index))).collect(Collectors.toList());
            TableValue.Wrapper wrapper = new TableValue.Wrapper();
            wrapper.setList(applyContentData);
            v = new TableValue(Collections.singletonList(wrapper));
        } else {
            v = dataValue;
        }
        return tmpControl.getProperty().toData(v);
    }

    ApprovalApplyRequest(String creatorUserid, String templateId, ApplyData<ApprovalContentData<? extends ContentDataValue>> applyData, List<Summary> summaryList, UseTemplateApprover useTemplateApprover) {
        this.creatorUserid = creatorUserid;
        this.templateId = templateId;
        this.applyData = applyData;
        this.summaryList = summaryList;
        this.useTemplateApprover = useTemplateApprover;
    }

    public ApprovalApplyRequest chooseDepartment(Long chooseDepartment) {
        this.chooseDepartment = chooseDepartment;
        return this;
    }

    ApprovalApplyRequest approver(List<Approver> approver) {
        this.approver = approver;
        return this;
    }

    ApprovalApplyRequest notifyer(List<String> notifyer) {
        this.notifyer = notifyer;
        return this;
    }

    ApprovalApplyRequest notifyType(ApprovalNotifyType notifyType) {
        this.notifyType = notifyType;
        return this;
    }

    public String toString() {
        return "ApprovalApplyRequest(creatorUserid=" + this.getCreatorUserid() + ", templateId=" + this.getTemplateId() + ", useTemplateApprover=" + (Object)((Object)this.getUseTemplateApprover()) + ", chooseDepartment=" + this.getChooseDepartment() + ", approver=" + this.getApprover() + ", notifyer=" + this.getNotifyer() + ", notifyType=" + (Object)((Object)this.getNotifyType()) + ", applyData=" + this.getApplyData() + ", summaryList=" + this.getSummaryList() + ")";
    }

    public String getCreatorUserid() {
        return this.creatorUserid;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public UseTemplateApprover getUseTemplateApprover() {
        return this.useTemplateApprover;
    }

    public Long getChooseDepartment() {
        return this.chooseDepartment;
    }

    public List<Approver> getApprover() {
        return this.approver;
    }

    public List<String> getNotifyer() {
        return this.notifyer;
    }

    public ApprovalNotifyType getNotifyType() {
        return this.notifyType;
    }

    public ApplyData<ApprovalContentData<? extends ContentDataValue>> getApplyData() {
        return this.applyData;
    }

    public List<Summary> getSummaryList() {
        return this.summaryList;
    }
}

