/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.approval;

import cn.felord.domain.approval.ContentDataValue;
import cn.felord.enumeration.ContactCtrlMode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ContactValue
implements ContentDataValue {
    @JsonIgnore
    private ContactCtrlMode contactCtrlMode;
    private List<MemberInfo> members;
    private Set<ApprovalDeptInfo> departments;

    public static ContactValue user(List<MemberInfo> members) {
        ContactValue contactValue = new ContactValue();
        contactValue.contactCtrlMode = ContactCtrlMode.USER;
        contactValue.members = members;
        contactValue.departments = Collections.emptySet();
        return contactValue;
    }

    public static ContactValue dept(Set<ApprovalDeptInfo> departments) {
        ContactValue contactValue = new ContactValue();
        contactValue.contactCtrlMode = ContactCtrlMode.DEPARTMENT;
        contactValue.members = Collections.emptyList();
        contactValue.departments = departments;
        return contactValue;
    }

    public void setMembers(List<MemberInfo> members) {
        this.contactCtrlMode = ContactCtrlMode.USER;
        this.members = members;
        this.departments = Collections.emptySet();
    }

    public void setDepartments(Set<ApprovalDeptInfo> departments) {
        this.contactCtrlMode = ContactCtrlMode.DEPARTMENT;
        this.members = Collections.emptyList();
        this.departments = departments;
    }

    public String toString() {
        return "ContactValue(contactCtrlMode=" + (Object)((Object)this.getContactCtrlMode()) + ", members=" + this.getMembers() + ", departments=" + this.getDepartments() + ")";
    }

    public ContactCtrlMode getContactCtrlMode() {
        return this.contactCtrlMode;
    }

    public List<MemberInfo> getMembers() {
        return this.members;
    }

    public Set<ApprovalDeptInfo> getDepartments() {
        return this.departments;
    }

    public static class ApprovalDeptInfo {
        private final Long openapiId;
        private final String name;

        @JsonCreator
        public ApprovalDeptInfo(@JsonProperty(value="openapi_id") Long openapiId, @JsonProperty(value="name") String name) {
            this.openapiId = openapiId;
            this.name = name;
        }

        public String toString() {
            return "ContactValue.ApprovalDeptInfo(openapiId=" + this.getOpenapiId() + ", name=" + this.getName() + ")";
        }

        public Long getOpenapiId() {
            return this.openapiId;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class MemberInfo {
        private final String userid;
        private final String name;

        @JsonCreator
        public MemberInfo(@JsonProperty(value="userid") String userid, @JsonProperty(value="name") String name) {
            this.userid = userid;
            this.name = name;
        }

        public String toString() {
            return "ContactValue.MemberInfo(userid=" + this.getUserid() + ", name=" + this.getName() + ")";
        }

        public String getUserid() {
            return this.userid;
        }

        public String getName() {
            return this.name;
        }
    }
}

