/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.media;

import cn.felord.WeComException;
import cn.felord.utils.FileTools;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.MediaType;

public class MultipartResource {
    private static final Pattern pattern = Pattern.compile("\\.([^.]+)$");
    private final MediaType mediaType;
    private final String fileName;
    private final byte[] source;

    public MultipartResource(String fileName, InputStream inputStream) throws IOException {
        this(null, fileName, inputStream);
    }

    public MultipartResource(MediaType mediaType, String fileName, InputStream inputStream) throws IOException {
        this(mediaType, fileName, FileTools.copyToByteArray(inputStream));
    }

    public MultipartResource(String fileName, byte[] source) {
        this(null, fileName, source);
    }

    public MultipartResource(MediaType mediaType, String fileName, byte[] source) {
        Matcher matcher = pattern.matcher(fileName);
        if (!matcher.find()) {
            throw new WeComException("the fileName must have extension, eg. pic.png");
        }
        this.mediaType = mediaType;
        this.fileName = fileName;
        this.source = source;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public byte[] getSource() {
        return this.source;
    }
}

