/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.message;

import cn.felord.domain.common.MediaId;
import cn.felord.domain.externalcontact.ContentText;
import cn.felord.domain.message.AbstractCard;
import cn.felord.domain.message.FileMessageBody;
import cn.felord.domain.message.ImageMessageBody;
import cn.felord.domain.message.MarkdownMessageBody;
import cn.felord.domain.message.MessageNews;
import cn.felord.domain.message.MessageTextCard;
import cn.felord.domain.message.MessageVideo;
import cn.felord.domain.message.MiniprogramMessageBody;
import cn.felord.domain.message.MiniprogramNotice;
import cn.felord.domain.message.MpNewsArticle;
import cn.felord.domain.message.MpNewsMessageBody;
import cn.felord.domain.message.NewsArticle;
import cn.felord.domain.message.NewsMessageBody;
import cn.felord.domain.message.TemplateCardMessageBody;
import cn.felord.domain.message.TextCardMessageBody;
import cn.felord.domain.message.TextMessageBody;
import cn.felord.domain.message.VideoMessageBody;
import cn.felord.domain.message.VoiceMessageBody;
import java.util.List;

public final class MessageBodyBuilders {
    private MessageBodyBuilders() {
    }

    public static TextMessageBody.Builder textMessageBodyBuilder(ContentText text) {
        return new TextMessageBody.Builder(text);
    }

    public static ImageMessageBody.Builder imageMessageBodyBuilder(MediaId image) {
        return new ImageMessageBody.Builder(image);
    }

    public static VoiceMessageBody.Builder voiceMessageBodyBuilder(MediaId voice) {
        return new VoiceMessageBody.Builder(voice);
    }

    public static VideoMessageBody.Builder videoMessageBodyBuilder(MessageVideo video) {
        return new VideoMessageBody.Builder(video);
    }

    public static FileMessageBody.Builder fileMessageBodyBuilder(MediaId file) {
        return new FileMessageBody.Builder(file);
    }

    public static TextCardMessageBody.Builder textCardMessageBodyBuilder(MessageTextCard textcard) {
        return new TextCardMessageBody.Builder(textcard);
    }

    @Deprecated
    public static NewsMessageBody.Builder newsMessageBodyBuilder(MessageNews<NewsArticle> news) {
        return new NewsMessageBody.Builder(news);
    }

    public static NewsMessageBody.Builder newsMessageBodyBuilder(List<NewsArticle> news) {
        return new NewsMessageBody.Builder(new MessageNews<NewsArticle>(news));
    }

    @Deprecated
    public static MpNewsMessageBody.Builder mpNewsMessageBodyBuilder(MessageNews<MpNewsArticle> mpnews) {
        return new MpNewsMessageBody.Builder(mpnews);
    }

    public static MpNewsMessageBody.Builder mpNewsMessageBodyBuilder(List<MpNewsArticle> mpnews) {
        return new MpNewsMessageBody.Builder(new MessageNews<MpNewsArticle>(mpnews));
    }

    public static MarkdownMessageBody.Builder markdownMessageBodyBuilder(ContentText markdown) {
        return new MarkdownMessageBody.Builder(markdown);
    }

    public static MiniprogramMessageBody.Builder miniprogramMessageBodyBuilder(MiniprogramNotice miniprogramNotice) {
        return new MiniprogramMessageBody.Builder(miniprogramNotice);
    }

    public static <M extends AbstractCard> TemplateCardMessageBody.Builder<M> templateCardMessageBodyBuilder(M templateCard) {
        return new TemplateCardMessageBody.Builder<M>(templateCard);
    }
}

