/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.message;

import cn.felord.domain.message.AbstractMessageBody;
import cn.felord.domain.message.MessageNews;
import cn.felord.domain.message.NewsArticle;
import cn.felord.enumeration.BoolEnum;

public class NewsMessageBody
extends AbstractMessageBody {
    private final MessageNews<NewsArticle> news;
    private final BoolEnum enableIdTrans;

    protected NewsMessageBody(String touser, String toparty, String totag, BoolEnum enableIdTrans, BoolEnum enableDuplicateCheck, Integer duplicateCheckInterval, MessageNews<NewsArticle> news) {
        super("news", touser, toparty, totag, null, enableDuplicateCheck, duplicateCheckInterval);
        this.news = news;
        this.enableIdTrans = enableIdTrans;
    }

    public MessageNews<NewsArticle> getNews() {
        return this.news;
    }

    public BoolEnum getEnableIdTrans() {
        return this.enableIdTrans;
    }

    public static class Builder {
        private final MessageNews<NewsArticle> news;
        private String touser;
        private String toparty;
        private String totag;
        private BoolEnum enableIdTrans;
        private BoolEnum enableDuplicateCheck;
        private Integer duplicateCheckInterval;

        protected Builder(MessageNews<NewsArticle> news) {
            this.news = news;
        }

        public Builder touser(String touser) {
            this.touser = touser;
            return this;
        }

        public Builder toparty(String toparty) {
            this.toparty = toparty;
            return this;
        }

        public Builder totag(String totag) {
            this.totag = totag;
            return this;
        }

        public Builder enableIdTrans(BoolEnum enableIdTrans) {
            this.enableIdTrans = enableIdTrans;
            return this;
        }

        public Builder enableDuplicateCheck(BoolEnum enableDuplicateCheck) {
            this.enableDuplicateCheck = enableDuplicateCheck;
            return this;
        }

        public Builder duplicateCheckInterval(Integer duplicateCheckInterval) {
            this.duplicateCheckInterval = duplicateCheckInterval;
            return this;
        }

        public NewsMessageBody build() {
            return new NewsMessageBody(this.touser, this.toparty, this.totag, this.enableIdTrans, this.enableDuplicateCheck, this.duplicateCheckInterval, this.news);
        }
    }
}

