/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.enumeration;

import cn.felord.xml.convert.PayCallbackEventTypeConverter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.util.Arrays;
import java.util.Objects;

@XStreamConverter(value=PayCallbackEventTypeConverter.class)
public enum PayCallbackEventType {
    TRANSACTION_SUCCESS("TRANSACTION.SUCCESS"),
    REFUND_SUCCESS("REFUND.SUCCESS"),
    REFUND_ABNORMAL("REFUND.ABNORMAL"),
    REFUND_CLOSED("REFUND.CLOSED");

    private final String event;

    private PayCallbackEventType(String event) {
        this.event = event;
    }

    @JsonValue
    public String getType() {
        return this.event;
    }

    @JsonCreator
    public static PayCallbackEventType deserialize(String event) {
        return Arrays.stream(PayCallbackEventType.values()).filter(eventType -> Objects.equals(eventType.event, event)).findFirst().orElse(null);
    }
}

