/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.callbacks;

import cn.felord.WeComException;
import cn.felord.callback.AbstractCallbackCrypto;
import cn.felord.callback.CallbackAsyncConsumer;
import cn.felord.callback.CallbackDecrypted;
import cn.felord.callback.CallbackSettings;
import cn.felord.callbacks.CallbackEventBody;
import cn.felord.callbacks.CallbackSettingsService;
import cn.felord.callbacks.CallbackXmlBody;
import cn.felord.domain.callback.CallbackResource;
import cn.felord.domain.corpay.miniapppay.callback.RefundCallbackData;
import cn.felord.domain.corpay.miniapppay.callback.TransactionCallbackData;
import cn.felord.enumeration.CallbackEvent;
import cn.felord.enumeration.PayCallbackEventType;
import cn.felord.retrofit.json.JacksonObjectMapperFactory;
import cn.felord.utils.Algorithms;
import cn.felord.xml.XmlReader;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;

public class CallbackCrypto
extends AbstractCallbackCrypto<CallbackEventBody> {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.create();
    private final CallbackSettingsService callbackSettingsService;

    public CallbackCrypto(XmlReader xmlReader, CallbackSettingsService callbackSettingsService, CallbackAsyncConsumer<CallbackEventBody> callbackAsyncConsumer) {
        super(xmlReader, callbackAsyncConsumer);
        this.callbackSettingsService = callbackSettingsService;
    }

    public String encryptJsonMsg(String agentId, String corpId, String replyMsg, String timeStamp, String nonce) throws WeComException {
        CallbackSettings callbackSettings = this.callbackSettingsService.loadAuthentication(agentId, corpId);
        return this.encryptJsonMsg(callbackSettings, replyMsg, timeStamp, nonce);
    }

    public String encryptXmlMsg(String agentId, String corpId, String replyMsg, String timeStamp, String nonce) throws WeComException {
        CallbackSettings callbackSettings = this.callbackSettingsService.loadAuthentication(agentId, corpId);
        return this.encryptXmlMsg(callbackSettings, replyMsg, timeStamp, nonce);
    }

    public <R> R accept(String agentId, String corpId, String msgSignature, String timeStamp, String nonce, String xmlBody, R response) {
        return this.doAccept(agentId, corpId, msgSignature, timeStamp, nonce, xmlBody, response);
    }

    public String accept(String agentId, String corpId, String msgSignature, String timeStamp, String nonce, String xmlBody) {
        return this.doAccept(agentId, corpId, msgSignature, timeStamp, nonce, xmlBody, "success");
    }

    private <T> T doAccept(String agentId, String corpId, String msgSignature, String timeStamp, String nonce, String xmlBody, T response) {
        CallbackXmlBody callbackXmlBody = (CallbackXmlBody)this.readXml(xmlBody, CallbackXmlBody.class);
        String encrypt = callbackXmlBody.getEncrypt();
        CallbackSettings callbackSettings = this.callbackSettingsService.loadAuthentication(agentId, corpId);
        String xml = this.decryptMsg(callbackSettings, msgSignature, timeStamp, nonce, encrypt);
        CallbackEventBody eventBody = (CallbackEventBody)this.readXml(xml, CallbackEventBody.class);
        eventBody.setAgentId(agentId);
        eventBody.setMsgSignature(msgSignature);
        eventBody.setTimeStamp(timeStamp);
        eventBody.setNonce(nonce);
        eventBody.setEncrypt(encrypt);
        eventBody.setXmlAgentId(callbackXmlBody.getAgentId());
        eventBody.setOriginalXml(xml);
        PayCallbackEventType eventType = eventBody.getEventType();
        if (Objects.nonNull((Object)eventType)) {
            this.payCallback(eventBody, callbackSettings);
        }
        return (T)this.accept(eventBody, response);
    }

    private void payCallback(CallbackEventBody eventBody, CallbackSettings callbackSettings) {
        CallbackResource resource = eventBody.getResource();
        String associatedData = resource.getAssociatedData();
        String nonce = resource.getNonce();
        String ciphertext = resource.getCiphertext();
        String json = Algorithms.aesDecode((byte[])callbackSettings.getAesKey(), (String)associatedData, (String)nonce, (String)ciphertext);
        PayCallbackEventType eventType = eventBody.getEventType();
        if (Objects.equals((Object)eventType, (Object)PayCallbackEventType.TRANSACTION_SUCCESS)) {
            try {
                TransactionCallbackData transactionCallbackData = (TransactionCallbackData)MAPPER.readValue(json, TransactionCallbackData.class);
                eventBody.setTransactionCallbackData(transactionCallbackData);
            }
            catch (JsonProcessingException e) {
                throw new WeComException("pay transaction callback error on json conversion", e);
            }
        }
        if (Objects.equals((Object)eventType, (Object)PayCallbackEventType.REFUND_CLOSED) || Objects.equals((Object)eventType, (Object)PayCallbackEventType.REFUND_ABNORMAL) || Objects.equals((Object)eventType, (Object)PayCallbackEventType.REFUND_SUCCESS)) {
            eventBody.setEvent(CallbackEvent.PAY_REFUND);
            try {
                RefundCallbackData refundCallbackData = (RefundCallbackData)MAPPER.readValue(json, RefundCallbackData.class);
                eventBody.setRefundCallbackData(refundCallbackData);
            }
            catch (JsonProcessingException e) {
                throw new WeComException("pay refund callback error on json conversion", e);
            }
        }
        eventBody.setMsgType("event");
    }

    public String decryptMsg(String agentId, String corpId, String msgSignature, String timeStamp, String nonce, String encrypt) {
        CallbackSettings callbackSettings = this.callbackSettingsService.loadAuthentication(agentId, corpId);
        return this.decryptMsg(callbackSettings, msgSignature, timeStamp, nonce, encrypt);
    }

    public String decryptMsg(CallbackSettings callbackSettings, String msgSignature, String timeStamp, String nonce, String encrypt) {
        CallbackDecrypted decrypted = this.doDecryptMsg(callbackSettings, msgSignature, timeStamp, nonce, encrypt);
        if (!Objects.equals(decrypted.getReceiveid(), callbackSettings.getReceiveid())) {
            throw new WeComException("invalid corpid");
        }
        return decrypted.getContent();
    }

    public CallbackDecrypted doDecryptMsg(CallbackSettings callbackSettings, String msgSignature, String timeStamp, String nonce, String encrypt) {
        String token = callbackSettings.getToken();
        String signature = Algorithms.sha1Signature((String)token, (String)timeStamp, (String)nonce, (String)encrypt);
        if (!Objects.equals(msgSignature, signature)) {
            throw new WeComException("callback signature not matched");
        }
        return this.decrypt(callbackSettings, msgSignature, timeStamp, nonce, encrypt);
    }
}

