/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.approval;

import cn.felord.WeComException;
import cn.felord.domain.approval.ApplyContentData;
import cn.felord.domain.approval.ApplyData;
import cn.felord.domain.approval.ApprovalContentData;
import cn.felord.domain.approval.ContentDataValue;
import cn.felord.domain.approval.ControlConfig;
import cn.felord.domain.approval.ListContentDataValue;
import cn.felord.domain.approval.Summary;
import cn.felord.domain.approval.TableConfig;
import cn.felord.domain.approval.TableCtrlProperty;
import cn.felord.domain.approval.TableValue;
import cn.felord.domain.approval.TmpControl;
import cn.felord.enumeration.UseTemplateApprover;
import cn.felord.utils.CollectionUtils;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public abstract class AbstractApprovalApplyRequest {
    private final String creatorUserid;
    private final String templateId;
    private final UseTemplateApprover useTemplateApprover;
    private final ApplyData<ApprovalContentData<? extends ContentDataValue>> applyData;
    private final List<Summary> summaryList;
    private Long chooseDepartment;

    AbstractApprovalApplyRequest(String creatorUserid, String templateId, UseTemplateApprover useTemplateApprover, ApplyData<ApprovalContentData<? extends ContentDataValue>> applyData, List<Summary> summaryList) {
        this.creatorUserid = creatorUserid;
        this.templateId = templateId;
        this.useTemplateApprover = useTemplateApprover;
        this.applyData = applyData;
        this.summaryList = summaryList;
    }

    public AbstractApprovalApplyRequest chooseDepartment(Long chooseDepartment) {
        this.chooseDepartment = chooseDepartment;
        return this;
    }

    static ApplyData<ApprovalContentData<? extends ContentDataValue>> applyData(List<TmpControl<? extends ControlConfig>> controls, List<? extends ContentDataValue> dataValues) {
        int valueSize;
        int ctrlSize = controls.size();
        if (ctrlSize != (valueSize = dataValues.size())) {
            throw new WeComException("controls size do not match dataValues size");
        }
        List contents = IntStream.range(0, ctrlSize).mapToObj(index -> AbstractApprovalApplyRequest.toControlValue((TmpControl)controls.get(index), (ContentDataValue)dataValues.get(index))).collect(Collectors.toList());
        return new ApplyData<ApprovalContentData<? extends ContentDataValue>>(contents);
    }

    private static ApprovalContentData<ContentDataValue> toControlValue(TmpControl<? extends ControlConfig> tmpControl, ContentDataValue dataValue) {
        ControlConfig config = tmpControl.getConfig();
        if (config != null && config.getClass().isAssignableFrom(TableConfig.class)) {
            ListContentDataValue internalValue = (ListContentDataValue)dataValue;
            if (internalValue == null) {
                throw new IllegalArgumentException("approval internalValue must not be null");
            }
            List<List<? extends ContentDataValue>> tableValues = internalValue.getValues();
            if (CollectionUtils.isEmpty(tableValues)) {
                throw new IllegalArgumentException("approval table values must not be empty");
            }
            TableConfig tableConfig = (TableConfig)config;
            List<TableCtrlProperty> children = tableConfig.getTable().getChildren();
            List<TableValue.Wrapper> collect = tableValues.stream().map(tableVal -> {
                int tableValSize = tableVal.size();
                if (tableValSize != children.size()) {
                    throw new IllegalArgumentException("table controls size do not match table dataValues size");
                }
                return IntStream.range(0, tableValSize).mapToObj(index -> ApplyContentData.from(((TableCtrlProperty)children.get(index)).getProperty(), (ContentDataValue)tableVal.get(index))).collect(Collectors.toList());
            }).map(TableValue.Wrapper::new).collect(Collectors.toList());
            return tmpControl.getProperty().toData(new TableValue(collect));
        }
        return tmpControl.getProperty().toData(dataValue);
    }

    public String toString() {
        return "AbstractApprovalApplyRequest(creatorUserid=" + this.getCreatorUserid() + ", templateId=" + this.getTemplateId() + ", useTemplateApprover=" + (Object)((Object)this.getUseTemplateApprover()) + ", applyData=" + this.getApplyData() + ", summaryList=" + this.getSummaryList() + ", chooseDepartment=" + this.getChooseDepartment() + ")";
    }

    public String getCreatorUserid() {
        return this.creatorUserid;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public UseTemplateApprover getUseTemplateApprover() {
        return this.useTemplateApprover;
    }

    public ApplyData<ApprovalContentData<? extends ContentDataValue>> getApplyData() {
        return this.applyData;
    }

    public List<Summary> getSummaryList() {
        return this.summaryList;
    }

    public Long getChooseDepartment() {
        return this.chooseDepartment;
    }
}

