/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.approval;

import cn.felord.domain.approval.ApprovalTitle;
import cn.felord.domain.approval.ControlConfig;
import cn.felord.domain.approval.TemplateContent;
import cn.felord.domain.approval.TmpControl;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

public class ApprovalTempAddRequest {
    private final List<ApprovalTitle> templateName;
    private final TemplateContent templateContent;

    public ApprovalTempAddRequest(List<ApprovalTitle> templateName, TemplateContent templateContent) {
        this.templateName = templateName;
        this.templateContent = templateContent;
    }

    public static ApprovalTempAddRequest from(@NonNull String templateName, @NonNull List<TmpControl<? extends ControlConfig>> controls) {
        if (templateName == null) {
            throw new NullPointerException("templateName is marked non-null but is null");
        }
        if (controls == null) {
            throw new NullPointerException("controls is marked non-null but is null");
        }
        return new ApprovalTempAddRequest(Collections.singletonList(ApprovalTitle.zhCN(templateName)), new TemplateContent(controls));
    }

    public List<ApprovalTitle> getTemplateName() {
        return this.templateName;
    }

    public TemplateContent getTemplateContent() {
        return this.templateContent;
    }
}

